#ifndef __FIRE_BILBOARD_H
#define __FIRE_BILBOARD_H

#include <d3dx8math.h>
#include "../engine/resource/ResourceId.h"

class CFireBillboard {
public:
	CFireBillboard();
	CFireBillboard( CResourceId pic );
	void update();

	void reset( const D3DXVECTOR3& pos, const D3DXVECTOR3& velocity, float gravity, int lifeTime, float size, D3DCOLOR color );

	bool isAlive() { return mLifeTime >= 0; }


public:
	D3DXVECTOR3		mPosition;
	D3DXVECTOR3		mVelocity;
	float			mGravity;
	int				mLifeTime;
	int				mLifeTimeAll;
	float			mSize;
	D3DCOLOR		mColor;

	CResourceId		mPictureId;
};


#endif
