#include "ItemEntity.h"

#include "MyGame.h"
#include "EngineConstants.h"
#include "../engine/Terrain.h"
#include "../utils/Random.h"

const int CItemEntity::MAX_LIFE = 10000;

CItemEntity::CItemEntity()
: mYours( true ), mLife( 0 ), mType( NONE )
{
}

void CItemEntity::update()
{
	CSector& sLast = CMyGame::getInstance().mGrid->getSectorByPosition( getOldPosition().x, getOldPosition().y );
    if( sLast.mItem == this ) sLast.mItem = NULL;

	mLife++;
	if( mLife > MAX_LIFE ) reset();

	getOldPosition() = getPosition();

	CSector& sNow = CMyGame::getInstance().mGrid->getSectorByPosition( getPosition().x, getPosition().y );
	sNow.mItem = this;

	if( !mYours )
		getPosition().z = CMyGame::getInstance().mTerrainTop->getAltitude( getPosition().x, getPosition().y ) - getSize();
	else getPosition().z = CMyGame::getInstance().getTerrain().getAltitude( getPosition().x, getPosition().y ) + getSize();
}

void CItemEntity::reset()
{
	float bound = 50;
	getPosition() = D3DXVECTOR3( bound + random::randf(gcon::WORLD_X - bound * 2), bound + random::randf(gcon::WORLD_Y - bound * 2), 0.0f );
}

CItemEntity::eType CItemEntity::getRandom()
{
	int it = rand() % 6;

	switch( it ) {
		case 0 : return NONE;
		case 1 : return FIRE_3;
		case 2 : return FIRE_FAST;
		case 3 : return FIRE_BIG;
		case 4 : return FIRE_NORMAL;
		case 5 : return PIG;
		default : 
			assert( !"unknow type" );
			return NONE;
	}
}

CResourceId CItemEntity::getPicId( eType type )
{
	if( type == FIRE_3 ) return CResourceId("ItemFire_3.png");
	if( type == FIRE_FAST ) return CResourceId("ItemFire_Fast.png");
	if( type == FIRE_BIG ) return CResourceId("ItemFire_Big.png");
	if( type == FIRE_NORMAL ) return CResourceId("ItemFire_Normal.png");
	if( type == PIG ) return CResourceId("ItemPig.png");
	if( type == NONE ) return CResourceId("ItemNone.png");
	if( type == UNKNOWN ) return CResourceId("ItemUnknown.png");

	assert( !"Unknow type" );
	return CResourceId("ItemNone.png");
}

int CItemEntity::getNum( eType type )
{
	if( type == NONE )			return 0;
	if( type == FIRE_3 )		return 1;
	if( type == FIRE_FAST )		return 2;
	if( type == FIRE_BIG )		return 3;
	if( type == FIRE_NORMAL )	return 4;
	if( type == PIG )			return 5;
	if( type == UNKNOWN )		return 6;

	assert( !"Unknow type" );
	return 0;
}

CItemEntity::eType CItemEntity::getType( int num )
{
	if( num == 0 )	return NONE;
	if( num == 1 )	return FIRE_3;
	if( num == 2 )	return FIRE_FAST;
	if( num == 3 )	return FIRE_BIG;
	if( num == 4 )	return FIRE_NORMAL;
	if( num == 5 )	return PIG;
	if( num == 6 )	return UNKNOWN;

	assert( !"Unknow type" );
	return NONE;
}