#ifndef __ITEM_ENTITY_H
#define __ITEM_ENTITY_H

#include "../engine/Entity.h"
#include "../engine/resource/resourceId.h"

class CItemEntity : public CEntity {
public:
	enum eType { NONE, FIRE_3, FIRE_FAST, FIRE_BIG, FIRE_NORMAL, PIG, UNKNOWN };

	CItemEntity();
	void update();

	void reset();

	eType getRandom();

	static CResourceId getPicId( eType type );

	static int getNum( eType type );
	static eType getType( int num );

public:
	static const int MAX_LIFE;
	eType mType;
	bool mYours;
	int mLife;
};


#endif
