#pragma warning(disable:4786)

//#include <d3dx8math.h>
#include "MyGame.h"
#include "../engine/Billboarder.h"
#include "../engine/EntityRenderer.h"
#include "../engine/Mesh.h"
#include "../engine/Terrain.h"
#include "../engine/TerrainPicker.h"
#include "../engine/TerrainGen.h"
#include "../engine/TextRenderer.h"
#include "../engine/camera/BasicCamera.h"
#include "../engine/resource/PictureBundle.h"
#include "../engine/animator/Animator.h"
#include "../engine/animator/AnimationSet.h"
#include "../utils/Config.h"

#include "MyTerrainGen.h"

// ENGINE CONSTANTS
#include "EngineConstants.h"
#include "../utils/Random.h"

#include <cassert>


// ------------------------------------------------------------------
//  basic stuff

int CMyGame::BALL_COUNT = 1;
const int CMyGame::CLOUD_COUNT = 1;
//int CMyGame::GODLESS_COUNT = 10000;
int CMyGame::GODLESS_COUNT = 1;
const float CMyGame::STONE_RADIUS = 30;
const float CMyGame::STONE_RADIUS_2 = STONE_RADIUS * STONE_RADIUS;
const int CMyGame::BOMB_COUNT = 30;
int CMyGame::DUMMY_COUNT = 10000;
const int CMyGame::FIRE_BILBOARD_COUNT = 500;
const int CMyGame::SHOOT_BILBOARD_COUNT = 500;
const int CMyGame::ITEM_COUNT = 50;

CMyGame::CMyGame( CConfig& config )
:	CBaseGame( config ),
	mTerrainCamera( NULL ),
	mPool( NULL ),
	mCurrentBall( 0 ),
	mTerrainWaterTop( NULL ),
	mTerrainWaterBottom( NULL ),
	mGodlessDeadCount( 0 ),
	mGodFound( 0 ),
	mM1Pressed( false ),
	mM2Pressed( false ),
//	mGameStarted( false ),
	mPlayer( NULL ),
	mOponent( NULL ),
	mTerrainTop( NULL ),
	mGrid( NULL ),
	mBombEntityPool( NULL ),
	mLastBombTime( 1000 ),
	mDummyEntityPool( NULL ),
	mNetClient( NULL ),
	//mLastConnect( 0 ),
	mBombDropped( 0 ),
	mOwnedOponent( 0 ),
	mYoursCount( 0 ),
	mVictory( 0.1f ),
	mFireBillboardPool( NULL ),
	mShootBillboardPool( NULL ),
	mItemEntityPool( NULL ),
	mConnectionStatus( "" ),
	mConnectRetry( 0 ),
	mShootOponent( 100 )
{
}

CMyGame::~CMyGame()
{
	delete mPool;
	delete mGrid;
	delete mBombEntityPool;
	delete mDummyEntityPool;
	delete mFireBillboardPool;
	delete mShootBillboardPool;
	delete mItemEntityPool;
}

float minT = -200;
float maxT = 0;
float waterLine = -150;

CCamera* CMyGame::createCamera()
{
	mTerrainCamera = new CBasicCamera();
	mTerrainCamera->getPosition() = D3DXVECTOR3( gcon::WORLD_X * 0.5f, gcon::WORLD_Y * 0.5f, 100.0f );


	mTerrainTop = new CTerrain( 
		//CResourceId( "TerrainWater.sha" ), 
		CResourceId( "TerrainTop.sha" ), 
		CResourceId( "TerrainGray.png" ), 
		1, 1 );

	CTerrainGen::fillTexture( *mTerrainTop, CResourceId("TerrainH.png"), -minT, -maxT );
	mTerrainTop->setTexture( CResourceId( "TerrainM.png" ) );
	CMyTerrainGen::resetSides( *mTerrainTop, 0 );

	getObjects().addObject( *mTerrainTop );


	return mTerrainCamera;
}

// ------------------------------------------------------------------
//  input

void CMyGame::onMouseLChange( bool pressed )
{
	mM1Pressed = pressed;
	//mGameStarted = true;

	//if( pressed ) modifyTerrain( -1 );
}

void CMyGame::modifyTerrain( float sign )
{
	//if( mGameStarted ) {
		D3DXVECTOR3 dir = getCamera().getCameraRay( getMouse().getMouseX(), getMouse().getMouseY() );
		D3DXVECTOR4 dir4;

		D3DXMATRIX m = getCamera().getCameraMatrix();
		m._41 = m._42 = m._43 = 0;

		D3DXVec3Transform( &dir4, &dir, &m );
		dir.x = dir4.x;
		dir.y = dir4.y;
		dir.z = dir4.z;

		CTerrainPick pick = CTerrainPicker::pick( getTerrain(), getCamera().getPosition(), dir );

		if( pick.isValid() ) {
			//assert( mCurrentBall < mBallEntityPool->size() );
			//TBallEntityPool::iterator it;
			//int i = 0;
			//for( it = mBallEntityPool->begin(); i < mCurrentBall; i++, it++ );

			//it->resetPosition( pick.getLocation() );

			//mCurrentBall++;
			//if( mCurrentBall >= mBallEntityPool->size() ) mCurrentBall = 0;

			float delta = 20 * sign;
			float dAll = delta / ( CTerrain::CELLS_X * CTerrain::CELLS_Y );

			getTerrain().beginUpdate();

			/*for( int xi = 0; xi < CTerrain::CELLS_X; xi++ )
				for( int yi = 0; yi < CTerrain::CELLS_Y; yi++ )
					getTerrain().setAltitude( xi, yi, getTerrain().getAltitudeIdx( xi, yi ) - dAll );*/

			int modSize = 2;

			float dReg = delta / ( ( modSize * 2 + 1 ) * ( modSize * 2 + 1 ) );

			int cx = pick.getCellX();
			int cy = pick.getCellY();

			for( int xi = -modSize; xi <= modSize; xi++ ) {
				int xxi = cx + xi;
				if( xxi < 0 || xxi >= CTerrain::CELLS_X ) continue;
				for( int yi = -modSize; yi <= modSize; yi++ ) {
					int yyi = cy + yi;
					if( yyi < 0 || yyi >= CTerrain::CELLS_Y ) continue;
					
					float l = dReg * ( cos( (float)xi / xxi * 2.8 ) * cos( (float)yi / yyi * 2.8 ) + 1.0f ) * 0.5f;

					getTerrain().setAltitude( xxi, yyi, getTerrain().getAltitudeIdx( xxi, yyi ) + l );
				}
			}

			getTerrain().setAltitude( pick.getCellX(), pick.getCellY(), getTerrain().getAltitudeIdx( pick.getCellX(), pick.getCellY() ) + delta );

			getTerrain().endUpdate();
		}
	//}
}

void CMyGame::onMouseRChange( bool pressed )
{
	//mGameStarted = true;

	mM2Pressed = pressed;

	//if( pressed ) modifyTerrain( 1 );
}

void CMyGame::onKeyChange( int key, bool pressed )
{
	//if( ( key == VK_RETURN ) && pressed ) mGameStarted = true;
}

void CMyGame::onProcessInput( const CFrameTime& frameTime )
{
	assert( mTerrainCamera );

	if( getKeyboard().isKeyPressed(VK_UP) )		mTerrainCamera->doMove( 70 );
	if( getKeyboard().isKeyPressed(VK_DOWN) )	mTerrainCamera->doMove( -70 );
	if( getKeyboard().isKeyPressed(VK_LEFT) )	mTerrainCamera->doYaw( 0.05f );
	if( getKeyboard().isKeyPressed(VK_RIGHT) )	mTerrainCamera->doYaw( -0.05f );
	if( getKeyboard().isKeyPressed(VK_RETURN) )	{
		if( mNetClient ) return;
		std::string server = getConfig().readS( "game", "server", "127.0.0.1" );
		unsigned long port = getConfig().readI( "game", "port", 7778 );

		mNetClient = new CNetClient( server, port );
		if( mNetClient->mID == 666 ) {
			delete mNetClient;
			mNetClient = NULL;
			
			mConnectionStatus = 
				getString( mConnectRetry ) + 
				" ) Failed to connect to server.\n" 
				"Please try againn. press <enter> ...\n\n" + 
				mConnectionStatus;

			mConnectRetry++;

			return;
		} else mConnectionStatus = "";

		if( mNetClient->mID != 0 ) {
			/*const CPicture& p = mPlayer->getPicture();
			mPlayer->setPicture( mOponent->getPicture() );
			mOponent->setPicture( p );*/

			const CPicture* yoursPic = CPictureBundle::getInstance().getResourceById( CResourceId("Dogbert.png") );
			const CPicture* oponentPic = CPictureBundle::getInstance().getResourceById( CResourceId("DilbertRot.png") );

			mPlayer->setPicture( *yoursPic );
			mOponent->setPicture( *oponentPic );

			mOponentPictureId = CResourceId("Dilbert.png");
			mYourPictureId = CResourceId("Dogbert.png");

			TDummyEntityPool::iterator it1;
			for( it1 = mDummyEntityPool->begin(); it1 != mDummyEntityPool->end(); it1++ ) {
				CDummyEntity& e = *it1;
				e.mYourPicture = yoursPic;
				e.mOponentPicture = oponentPic;
				e.setYours( e.mYours );
			}
		}
	}

	if( getKeyboard().isKeyPressed(VK_SPACE) && 
		mPlayer && 
		( mLastBombTime > mBombDeltaTime * ( mPlayer->mItem == CItemEntity::FIRE_FAST ? 0.2f : 1.0f ) ) )
	{
		mLastBombTime = 0;

		CBombEntity::fire( mPlayer->getPosition(), mPlayer->mCamera->getFront(), mPlayer->mCamera->getUp(), true, mPlayer->mItem );

		mBombDropped++;
	}

	//if( mCurrentBomb >= mBombEntityPool->size() ) mCurrentBomb = 0;

	if( mPlayer ) mPlayer->update();

	if( mOponent->mBombs > 0 ) {
		/*assert( mCurrentBomb < mBombEntityPool->size() );
		int i = 0;
		TBombEntityPool::iterator it;
		for( it = mBombEntityPool->begin(); i < mCurrentBomb; it++, i++ );

		it->reset( 
			mOponent->getPosition(), 
			mOponent->getAttackVelocity() + D3DXVECTOR3( random::randfs(0.1f), random::randfs(0.1f), random::randfs(0.1f) ), 
			false 
		);*/

		mOponent->useBomb( CBombEntity::fire( mOponent->getPosition(), mOponent->mDirection, mOponent->mUp, false, mOponent->mItem ) );

		//mCurrentBomb++;		
	}

	//if( mCurrentBomb >= mBombEntityPool->size() ) mCurrentBomb = 0;

	mLastBombTime += frameTime.getDelta();
}


void CMyGame::initCamera() 
{
	D3DXVECTOR3 center( gcon::WORLD_X * 0.5f, gcon::WORLD_Y * 0.5f, getTerrain().getAltitude( gcon::WORLD_X * 0.5f, gcon::WORLD_Y * 0.5f ) );

	mTerrainCamera->getPosition() = center + D3DXVECTOR3( 0, 150, 150 );

	orientCamera();
}

void CMyGame::orientCamera()
{
	D3DXVECTOR3 center( gcon::WORLD_X * 0.5f, gcon::WORLD_Y * 0.5f, getTerrain().getAltitude( gcon::WORLD_X * 0.5f, gcon::WORLD_Y * 0.5f ) );
	D3DXVECTOR3 d = center - mTerrainCamera->getPosition();
	float l = D3DXVec3Length( &d );
	D3DXVec3Normalize( &d, &d );
		
	D3DXVECTOR3 front = d;
	D3DXVECTOR3 up = mTerrainCamera->getUp();
	D3DXVECTOR3 right = mTerrainCamera->getRight();

	up = D3DXVECTOR3( 0, 0, 1 );

	front = d;
	D3DXVec3Cross( &right, &front, &up );		
	D3DXVec3Cross( &up, &right, &front );

	D3DXVec3Normalize( &front, &front );
	D3DXVec3Normalize( &up, &up );
	D3DXVec3Normalize( &right, &right );

	mTerrainCamera->getFront() = front;
	mTerrainCamera->getUp() = up;
	mTerrainCamera->getRight() = right;
}


// ------------------------------------------------------------------
//  initialization


void CMyGame::onInitialize()
{
	mTerrainWaterTop = new CTerrain( CResourceId( "TerrainWater.sha" ), CResourceId( "Water.png" ), 1, 1 );
	CTerrainGen::fillConst( *mTerrainWaterTop, -waterLine );
	getObjects().addObject( *mTerrainWaterTop );
	mTerrainWaterBottom = new CTerrain( CResourceId( "TerrainWater.sha" ), CResourceId( "Water.png" ), 1, 1 );
	CTerrainGen::fillConst( *mTerrainWaterBottom, waterLine );
	getObjects().addObject( *mTerrainWaterBottom );
	

	CTerrainGen::fillTexture( getTerrain(), CResourceId("TerrainH.png"), minT, maxT );
	getTerrain().setTexture( CResourceId( "TerrainM.png" ) );
	CMyTerrainGen::resetSides( getTerrain(), 0 );

	mVictory = getConfig().readF( "game", "victory", 0.2f );
	mBombDeltaTime = getConfig().readF( "game", "bombDelta", 0.5f );

	mTerrainCamera->setTerrain( getTerrain() );
	
	int maxEntities = getEntities().getMaxEntities();
	DUMMY_COUNT = getConfig().readI( "game", "dummy", 10000 );;

	//mPool = new TPool( maxEntities );
	mPool = new TPool( 20 );
	mBombEntityPool = new TBombEntityPool( BOMB_COUNT );
	mDummyEntityPool = new TDummyEntityPool( DUMMY_COUNT );
	mFireBillboardPool = new TFireBillboardPool( FIRE_BILBOARD_COUNT );
	mShootBillboardPool = new TShootBillboardPool( SHOOT_BILBOARD_COUNT );
	mItemEntityPool = new TItemEntityPool( ITEM_COUNT );

	mGrid = new TGrid();

	CPictureBundle& pb = CPictureBundle::getInstance();
	const CPicture& picGodless = *pb.getResourceById( CResourceId("Sprite.png") );
	const CPicture& picStone = *pb.getResourceById( CResourceId("Stone.png") );
	const CPicture& picDogbert = *pb.getResourceById( CResourceId("Dogbert.png") );
	const CPicture& picPlayer = *pb.getResourceById( CResourceId("Dogbert.png") );
	//const CPicture& picOponent = *pb.getResourceById( CResourceId("AngryGod.png") );
	const CPicture* picOponent;// = *pb.getResourceById( CResourceId("AngryGod.png") );

	mYourPictureId = CResourceId("Dilbert.png");
	mOponentPictureId = CResourceId("Dogbert.png");
		
	const CPicture* picYours = pb.getResourceById( CResourceId("Dilbert.png") );
	const CPicture* picOponents = pb.getResourceById( CResourceId("DogbertRot.png") );

	picOponent = picOponents;

	const CPicture& picBomb = *pb.getResourceById( CResourceId("bomb.png") );
	const CPicture& picExplosion = *pb.getResourceById( CResourceId("explosion.png") );

	CResourceId picFireId("explosion.png");
	CResourceId picShootId("angrygod.png");

	CResourceId* picCloud[4];
	picCloud[0] = new CResourceId("cloud0.png");
	picCloud[1] = new CResourceId("cloud1.png");
	picCloud[2] = new CResourceId("cloud2.png");
	picCloud[3] = new CResourceId("cloud3.png");

	const CPicture* picItemFire3 = pb.getResourceById( CResourceId("ItemFire_3.png") );
	const CPicture* picItemFireFast = pb.getResourceById( CResourceId("ItemFire_Fast.png") );
	const CPicture* picItemFireBig = pb.getResourceById( CResourceId("ItemFire_Big.png") );
	const CPicture* picItemFireNormal = pb.getResourceById( CResourceId("ItemFire_Normal.png") );
	const CPicture* picItemPig = pb.getResourceById( CResourceId("ItemPig.png") );
	const CPicture* picItemNone = pb.getResourceById( CResourceId("ItemNone.png") );
	const CPicture* picItemUnknown = pb.getResourceById( CResourceId("ItemUnknown.png") );

	int i;

	for( i = 0; i < ITEM_COUNT; ++i ) {
		CItemEntity& e = mItemEntityPool->add();

		getEntities().add( e );
		e.reset();
		e.getOldPosition() = e.getPosition();
		int item = rand() % 7;
		switch( item ) {
			case 0 :
				e.setPicture( *picItemFire3 );
				e.mType = CItemEntity::eType::FIRE_3;
				break;
			case 1 :
				e.setPicture( *picItemFireFast );
				e.mType = CItemEntity::eType::FIRE_FAST;
				break;
			case 2 :
				e.setPicture( *picItemFireBig );
				e.mType = CItemEntity::eType::FIRE_BIG;
				break;
			case 3 :
				e.setPicture( *picItemFireNormal );
				e.mType = CItemEntity::eType::FIRE_NORMAL;
				break;
			case 4 :
				e.setPicture( *picItemPig );
				e.mType = CItemEntity::eType::PIG;
				break;
			case 5 :
				e.setPicture( *picItemNone );
				e.mType = CItemEntity::eType::NONE;
				break;
			case 6 :
				e.setPicture( *picItemUnknown );
				e.mType = CItemEntity::eType::UNKNOWN;
				break;
			default: assert( !"unknown type" );
		}
		
		e.setSize( 5.0f );
		e.setColor( 0xFFFFFFFF );
		e.mYours = ( i & 1 ) == 0;
	}

	for( i = 0; i < FIRE_BILBOARD_COUNT; ++i ) 
		mFireBillboardPool->add( CFireBillboard( picFireId ) );
	
	mCurrentFire = mFireBillboardPool->begin();

	for( i = 0; i < SHOOT_BILBOARD_COUNT; ++i ) 
		mShootBillboardPool->add( CShootBillboard( picShootId ) );

	mCurrentShoot = mShootBillboardPool->begin();

	for( i = 0; i < BOMB_COUNT; ++i ) {
		CBombEntity& e = mBombEntityPool->add();
		getEntities().add( e );
		float bound = 50;
		e.getPosition() = D3DXVECTOR3( bound + random::randf(gcon::WORLD_X - bound * 2), bound + random::randf(gcon::WORLD_Y - bound * 2), 0.0f );
		//e.getPosition() = D3DXVECTOR3( random::randf(gcon::WORLD_X), random::randf(gcon::WORLD_Y), 0.0f );
		e.mVelocity = D3DXVECTOR3( 0, 0, 0 );
		e.getOldPosition() = e.getPosition();
		e.setPicture( picBomb );
		e.setSize( 0.0f );
		e.setColor( 0xFFFFFFFF );
		e.mBombPic = &picBomb;
		e.mExplosionPic = &picExplosion;
		e.setSize( 0.0f );
	}
	mCurrentBomb = mBombEntityPool->begin();

	//DUMMY_COUNT = 1;
	for( i = 0; i < DUMMY_COUNT; ++i ) {
		CDummyEntity& e = mDummyEntityPool->add( CDummyEntity( *picYours, *picOponents ) );
		getEntities().add( e );
		//e.getPosition() = D3DXVECTOR3( random::randf(gcon::WORLD_X), random::randf(gcon::WORLD_Y), 0.0f );
		float bound = 50;
		e.getPosition() = D3DXVECTOR3( bound + random::randf(gcon::WORLD_X - bound * 2), bound + random::randf(gcon::WORLD_Y - bound * 2), 0.0f );
		e.mVelocity = D3DXVECTOR3( random::randfs(3.0f), random::randfs(3.0f), 0.0f );
		e.getOldPosition() = e.getPosition();
		e.mDeciderCounter = 1;
		e.mDecider = NULL;
		e.setSize( 3.0f );
		e.setColor( 0xFFFFFFFF );
		e.mFlags = 0;

		e.setYours( ( i & 1 ) == 0 );
	}
	mYoursCount = DUMMY_COUNT / 2;

	mPlayer = new CPlayerEntity( mTerrainCamera );

	getEntities().add( *mPlayer );
	mPlayer->getPosition() = D3DXVECTOR3( random::randf(gcon::WORLD_X), random::randf(gcon::WORLD_Y), 0.0f );
	//mPlayer1->mVelocity = D3DXVECTOR3( random::randfs(3.0f), random::randf(3.0f), 0.0f );
	mPlayer->getOldPosition() = mPlayer->getPosition();
	mPlayer->mDeciderCounter = 1;
	mPlayer->mDecider = NULL;
	mPlayer->setPicture( picPlayer );
	mPlayer->setSize( 0.0f );
	mPlayer->setColor( 0xFFFFFFFF );
	mPlayer->mFlags = CMyEntity::F_KEEP_ON_TERRAIN;


	mOponent = new COponentEntity();

	getEntities().add( *mOponent );
	mOponent->getPosition() = D3DXVECTOR3( random::randf(gcon::WORLD_X), random::randf(gcon::WORLD_Y), 0.0f );
	mOponent->mDirection = D3DXVECTOR3( random::randfs(3.0f), random::randf(3.0f), 0.0f );
	mOponent->getOldPosition() = mOponent->getPosition();
	mOponent->setPicture( *picOponent );
	mOponent->setSize( 40.0f );
	mOponent->setColor( 0xFFFFFFFF );
	mOponent->reset( D3DXVECTOR3(0,0,0), D3DXVECTOR3(0,0,0), 0, 0 );
}


// ------------------------------------------------------------------
//  game logic


void CMyGame::onUpdate()
{
	if( mPlayer ) mPlayer->update();

	if( mNetClient ) {
		NetData* data = mNetClient->send( 
			mPlayer->getPosition(), 
			mPlayer->getDirection(), 
			mBombDropped, 
			mOwnedOponent,
			CItemEntity::getNum( mPlayer->mItem ),
			mShootOponent == 0
		);

		if( mNetClient->mHasSent ) {
			mBombDropped = 0;
			mOwnedOponent = 0;
		}
		
		if( data ) {
			if( data->mOwned > 0 ) {
				mYoursCount -= data->mOwned;
			}

			data->mPosition.z = -data->mPosition.z;
			data->mVelocity.z = -data->mVelocity.z;
			mOponent->reset( data->mPosition, data->mVelocity, data->mBombs, data->mOwned );

			if( mShootOponent > 0 ) mOponent->mItem = CItemEntity::getType( data->mItem );
			
			if( data->mShot ) mPlayer->mItem = CItemEntity::PIG;
		}
		if( mNetClient->mHasSent && mShootOponent < 255 ) mShootOponent++;
	}

	TItemEntityPool::iterator it4;
	for( it4 = mItemEntityPool->begin(); it4 != mItemEntityPool->end(); it4++ ) it4->update();

	TFireBillboardPool::iterator it2;
	for( it2 = mFireBillboardPool->begin(); it2 != mFireBillboardPool->end(); it2++ ) it2->update();

	TShootBillboardPool::iterator it3;
	for( it3 = mShootBillboardPool->begin(); it3 != mShootBillboardPool->end(); it3++ ) it3->update();
	
	TBombEntityPool::iterator it;
	for( it = mBombEntityPool->begin(); it != mBombEntityPool->end(); it++ ) {
		CBombEntity& e = *it;
		e.update();
	}

	TDummyEntityPool::iterator it1;
	for( it1 = mDummyEntityPool->begin(); it1 != mDummyEntityPool->end(); it1++ ) {
		CDummyEntity& e = *it1;
		e.update();
	}

	it1 = mDummyEntityPool->begin();
	while( mOponent->mOwned > 30 ) {
		if( it1 == mDummyEntityPool->end() ) break;
		CDummyEntity& e = *it1;
		if( e.mYours ) {
			e.setYours( false );
			mOponent->mOwned--;
		}
		it1++;
	}

	if( mOponent ) mOponent->update();
	
	mLastBombTime++;
}


// ------------------------------------------------------------------
//  rendering

void CMyGame::onRenderBeforeAll()
{
	getBillboarder().beginBillboards();

	if( (float)mYoursCount / DUMMY_COUNT < mVictory )
		getBillboarder().putScreenBill( mOponentPictureId, 0xc0ffffff, -0.5f, -0.5f, 0.5f, 0.5f );
	else if( (float)( DUMMY_COUNT - mYoursCount ) / DUMMY_COUNT < mVictory )
		getBillboarder().putScreenBill( mYourPictureId, 0xc0ffffff, -0.5f, -0.5f, 0.5f, 0.5f );

	float size = 0.1f;
	float ypos = 0.85f;

	float ddx = 0.1f;
	getBillboarder().putScreenBill( CResourceId( "lightnin.png" ), 0xd0ffffff, -ddx, ypos - ddx, ddx, ypos + size + ddx );

	float xp = -(float)( mYoursCount - DUMMY_COUNT * 0.5f ) * 2.0f / DUMMY_COUNT;
	getBillboarder().putScreenBill( mYourPictureId, 0xd0ffffff, xp - size, ypos, xp, ypos + size );
	getBillboarder().putScreenBill( mOponentPictureId, 0xd0ffffff, xp, ypos, xp + size, ypos + size );

	xp = ( 0.5 - mVictory ) * 2 + size;

	getBillboarder().putScreenBill( CResourceId( "Victory.png" ), 0xd0ffffff, -xp, ypos, -xp - size, ypos + size );
	getBillboarder().putScreenBill( CResourceId( "Victory.png" ), 0xd0ffffff, xp, ypos, xp + size, ypos + size );

	// fires
	TFireBillboardPool::iterator it;
	for( it = mFireBillboardPool->begin(); it != mFireBillboardPool->end(); it++ ) {
		CFireBillboard& f = *it;

		if( f.isAlive() ) getBillboarder().putWorldBill( f.mPictureId, f.mColor, f.mPosition, f.mSize, f.mSize );
	}

	TShootBillboardPool::iterator it1;
	for( it1 = mShootBillboardPool->begin(); it1 != mShootBillboardPool->end(); it1++ ) {
		CShootBillboard& f = *it1;

		if( f.isAlive() ) getBillboarder().putWorldBill( f.mPictureId, f.mColor, f.mPosition, f.mSize, f.mSize );
	}

	getBillboarder().endBillboards();

	float itemX0 = -0.95f;
	float itemY0 = 0.60f;
	float itemSize = 0.2f;

	getBillboarder().putScreenBill( CItemEntity::getPicId( mPlayer->mItem ), 0xd0ffffff, itemX0, itemY0, itemX0 + itemSize, itemY0 + itemSize );
}

void CMyGame::onRenderAfterWorld()
{
}

void CMyGame::onRenderAfterAll()
{
//	char buf[255];

	// text
	std::string s;

	if( mNetClient ) {
		s = "";

		s += "total units: " + getString( DUMMY_COUNT ) + "\n";
		s += "needed for vicotry: " + getString( (int)( ( 1 - mVictory ) * 100 ) ) + "\n";
		s += "your units: " + getString( mYoursCount ) + "\n";
		s += "your percent: " + getString( (int)((float)mYoursCount/DUMMY_COUNT * 100 ) ) + "\n";

		getTextRenderer().renderScreenText( 5, 20, s );

		if( (float)mYoursCount / DUMMY_COUNT < mVictory ) {
			s = "!!!! you looser.... !!!";

			getTextRenderer().renderScreenText( 80, 80, s, 0xffff0000 );
		} else if( (float)( DUMMY_COUNT - mYoursCount ) / DUMMY_COUNT < mVictory ) {
			s = "!!!! you win man. bilyv it !!!";

			getTextRenderer().renderScreenText( 80, 80, s, 0xffff0000 );
		}
	} else {
		s = "Dilber vs. Dogbert\n\n"
			"    jums priklauso apacioje esantys unitai. virsuje esantys junitai yra jusu priesininko. juos galima perimti\n"
			"apmetant granatomis. pataikius i viena is jus jis pereina i jusu puse. jusu priesininkas taip pat stengiasi\n"
			"perimti jusu unitus. taigi sekmes. jei ko nesupratot, niekuo negaliu padet - jau velu ir aiskiau neparasyciau,\n"
			"kad ir kaip noreciau:)). no offence. pys n restekpa."
			"    zaidimas zaidziamas tinkle dviese. ant vieno kopiuterio reikia paleisti serveri (server.bat). o kituose\n"
			"paleisti zaidmimus. serveris taip pat gali but paleistas ant to pacio kompiuterio kur ir viena is zaidmo\n"
			"programu. tik nepamirskite nustatyti 'server' konfiguracijos failuose.\n"
			"    unitu viso yra yra (" + getString( DUMMY_COUNT ) + "). tas kas pirmas surenka " + getString( ( 1 - mVictory ) * 100 ) + "% - laimi.\n"
			"lango apacioje esantis indikatorius pades jums orientuotis, kieno puseje yra tiesa.\n\n"
			"    valdymas: \n"
			". rodykles: sukiojimas ir judejimas\n"
			". space: meta granata\n\n"
			"paspaudus enter zaidimas laikinai sustos kol prisijungs antras zaidejas.\n\n\n"
			"<spauskite enter>";

		getTextRenderer().renderScreenText( 10, 20, s, 0xffffffff );
	}

	if( mConnectionStatus.compare("") != 0 )
		getTextRenderer().renderScreenText( 10, 310, mConnectionStatus, 0xffffffff );
}

std::string CMyGame::getString( int value ) 
{
	char buf[255];
	sprintf( buf, "%d", value );

	return buf;
}

CFireBillboard* CMyGame::nextFire()
{
	CFireBillboard* f = &(*mCurrentFire);

	mCurrentFire++;
	if( mCurrentFire == mFireBillboardPool->end() ) mCurrentFire = mFireBillboardPool->begin(); 

	return f;
}

CShootBillboard* CMyGame::nextShoot()
{
	CShootBillboard* f = &(*mCurrentShoot);

	mCurrentShoot++;
	if( mCurrentShoot == mShootBillboardPool->end() ) mCurrentShoot = mShootBillboardPool->begin(); 

	return f;
}

CBombEntity* CMyGame::nextBomb()
{
	CBombEntity* f = &(*mCurrentBomb);

	mCurrentBomb++;
	if( mCurrentBomb == mBombEntityPool->end() ) mCurrentBomb = mBombEntityPool->begin(); 

	return f;
}
