/**
 *  @file game/MyGame.h
 *  Your game application code.
 */

#ifndef __MY_GAME_H
#define __MY_GAME_H

#include "MyEntity.h"
#include "FireBilboard.h"
#include "ShootBilboard.h"
#include "BombEntity.h"
#include "ItemEntity.h"
#include "PlayerEntity.h"
#include "OponentEntity.h"
#include "DummyEntity.h"
#include "../engine/BaseGame.h"
#include "../engine/Grid.h"
#include "../engine/resource/REsourceId.h"
#include "../utils/FixedPool.h"
#include "../utils/Singleton.h"
#include "net/client/netclient.h"

class CSector {
public:
	CSector() : mBomb( NULL ), mItem( NULL ) {}

	CBombEntity* mBomb;
	CItemEntity* mItem;
};
typedef CGrid<CSector,16,16> TGrid;


class CBasicCamera;
/**
 *  Your game application class.
 */
class CMyGame : public CBaseGame, public CSingleton<CMyGame>
{
	static int GODLESS_COUNT;
	static int BALL_COUNT;
	static const int CLOUD_COUNT;
	static const int BOMB_COUNT;
	static int DUMMY_COUNT;
	static const int FIRE_BILBOARD_COUNT;
	static const int SHOOT_BILBOARD_COUNT;

	static const int ITEM_COUNT;
public:
	static const float STONE_RADIUS;
	static const float STONE_RADIUS_2;

	typedef CFixedPool<CMyEntity>		TPool;
	typedef CFixedPool<CBombEntity>		TBombEntityPool;
	typedef CFixedPool<CDummyEntity>	TDummyEntityPool;
	typedef CFixedPool<CFireBillboard>	TFireBillboardPool;
	typedef CFixedPool<CShootBillboard>	TShootBillboardPool;
	typedef CFixedPool<CItemEntity>		TItemEntityPool;

public:
	static void init( CConfig& config ) {
		CMyGame* game = new CMyGame( config ); assert( game );
		assignInstance( *game );
	}
	virtual ~CMyGame();

protected:
	/// Receive left mouse button change.
	virtual void	onMouseLChange( bool pressed );
	/// Receive right mouse button change.
	virtual void	onMouseRChange( bool pressed );
	/// Receive key state change.
	virtual void	onKeyChange( int key, bool pressed );
	
	/**
	 *  Initialize the game.
	 */
	virtual	void onInitialize();
	
	/**
	 *  Process input.
	 *  The engine calls this method for processing input.
	 */
	virtual void onProcessInput( const CFrameTime& frameTime );

	/**
	 *  Execute game logic.
	 *  The engine calls this method when game update time comes.
	 */
	virtual void onUpdate();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method before rendering anything.
	 */
	virtual void onRenderBeforeAll();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method after rendering all world
	 *  objects.
	 */
	virtual void onRenderAfterWorld();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method after rendering everything.
	 */
	virtual void onRenderAfterAll();

protected:
	virtual CCamera* createCamera();

private:
	CMyGame( CConfig& config );

	static CMyGame* createInstance() {
		assert( !"Must be initialized first" );
		return 0;
	}

	static void deleteInstance( CMyGame& instance ) {
		delete &instance;
	}

	void modifyTerrain( float sign );
	std::string getString( int value );
	void orientCamera();
	void initCamera();

	friend CSingleton<CMyGame>;	

private:
	CBasicCamera*	mTerrainCamera;

public:
	TPool*			mPool;
	int				mCurrentBall;
	TGrid*			mGrid;
	CTerrain*		mTerrainWaterTop;
	CTerrain*		mTerrainWaterBottom;
	CTerrain*		mTerrainTop;

	int mGodlessDeadCount;
	int mGodFound;
	bool mM1Pressed;
	bool mM2Pressed;

	//bool mGameStarted;

public:
	CPlayerEntity* mPlayer;
	COponentEntity* mOponent;
	TBombEntityPool* mBombEntityPool;
	TDummyEntityPool* mDummyEntityPool;
	TFireBillboardPool* mFireBillboardPool;
	TShootBillboardPool* mShootBillboardPool;
	TItemEntityPool* mItemEntityPool;
	float mLastBombTime;
	float mBombDeltaTime;
	CNetClient* mNetClient;
	//int mLastConnect;

	int mBombDropped;
	int mOwnedOponent;

	int mYoursCount;
	float mVictory;

	CResourceId mYourPictureId;
	CResourceId mOponentPictureId;

	TFireBillboardPool::iterator mCurrentFire;
	TShootBillboardPool::iterator mCurrentShoot;
	TBombEntityPool::iterator mCurrentBomb;

	CFireBillboard* nextFire();
	CShootBillboard* nextShoot();
	CBombEntity* nextBomb();

	std::string mConnectionStatus;
	int mConnectRetry;
	int mShootOponent;
};

#endif 