#include "OponentEntity.h"

#include "MyGame.h"
#include "../engine/Terrain.h"
#include "../utils/Random.h"
#include "ItemEntity.h"

COponentEntity::COponentEntity()
: mBombs( 0 ), mOwned( 0 ), mItem( CItemEntity::eType::NONE )
{
}

void COponentEntity::update()
{
	getOldPosition() = getPosition();

	float inf = 0.5f;

	D3DXVECTOR3 pos = getPosition() * 0.5 + mRezPosition * ( 1 - inf );
	mDirection = mDirection * 0.5 + mRezDirection * ( 1 - inf );
	
	//
	// bound to world

	correctPos( pos );

	pos.z = CMyGame::getInstance().mTerrainTop->getAltitude( pos.x, pos.y ) - 20;

	/*if( pos.z - 20 < CMyGame::getInstance().getTerrain().getAltitude( pos.x, pos.y ) ) {
		pos = getOldPosition() + D3DXVECTOR3( random::randf(gcon::WORLD_X), random::randf(gcon::WORLD_Y), 0.0f );
		correctPos( pos );
	}*/

	getPosition() = pos;

	orientDirection();

	// checking colision with bombs
	if( CMyGame::getInstance().mNetClient ) {
		// colision with bombs
		const CSector& s = CMyGame::getInstance().mGrid->getSectorByPosition( getPosition().x, getPosition().y );
					
		if( s.mBomb && !s.mBomb->isExploded() && s.mBomb->mYours ) {

			D3DXVECTOR3 d = getPosition() - s.mBomb->getPosition();

			float rMax = s.mBomb->getSize() + getSize();

			if( D3DXVec3LengthSq( &d ) < rMax * rMax ) {
				s.mBomb->explode();
		
				mItem = CItemEntity::PIG;
				CMyGame::getInstance().mShootOponent = 0;
			}
		}
	}

	if( mItem == CItemEntity::PIG ) setSize( 3.0f );
	else setSize( 40.0f );
}

void COponentEntity::orientDirection() 
{
	D3DXVECTOR3 pos = getPosition();

	float d = 5;

	D3DXVECTOR3 v1( pos.x - d, pos.y, 0 );
	if( v1.x < 0 ) v1.x = 0;
	D3DXVECTOR3 v2( pos.x, pos.y - d, 0 );
	if( v2.y < 0 ) v2.y = 0;

	v1 = D3DXVECTOR3( d, 0,
		CMyGame::getInstance().mTerrainTop->getAltitude( pos.x, pos.y ) -
		CMyGame::getInstance().mTerrainTop->getAltitude( v1.x, v1.y ) );

	v2 = D3DXVECTOR3( 0, d,
		CMyGame::getInstance().mTerrainTop->getAltitude( pos.x, pos.y ) -
		CMyGame::getInstance().mTerrainTop->getAltitude( v2.x, v2.y ) );

	D3DXVECTOR3 normal;

	D3DXVec3Cross( &normal, &v2, &v1 );
	D3DXVec3Normalize( &normal, &normal );

	float inf = 0.01f;

	D3DXVECTOR3 front = mDirection;
	D3DXVECTOR3 up = normal;
	D3DXVECTOR3 right;

	D3DXVec3Cross( &right, &front, &up );		
	D3DXVec3Cross( &front, &up, &right );

	D3DXVec3Normalize( &front, &front );
	D3DXVec3Normalize( &up, &up );
	//D3DXVec3Normalize( &right, &right );

	mDirection = front;
	mUp = up;
}

void COponentEntity::reset( const D3DXVECTOR3& rezPosition, const D3DXVECTOR3& rezDirection, int bombs, int owned )
{
	mRezPosition = rezPosition;
	mRezDirection = rezDirection;
	mBombs += bombs;
	mOwned += owned;
}

void COponentEntity::correctPos( D3DXVECTOR3& pos )
{
	float bound = 30;
	if( pos.x >= gcon::WORLD_X - bound || pos.x < bound ) { 
		pos.x = getOldPosition().x;
	}
	if( pos.y >= gcon::WORLD_Y - bound || pos.y < bound ) {
		pos.y = getOldPosition().y;
	}
}

void COponentEntity::useOwned() 
{ 
	assert( mOwned > 0 ); mOwned--; 
}

D3DXVECTOR3 COponentEntity::getAttackVelocity() 
{
	float dir = 0.6f;
	return ( mDirection * dir + mUp * ( 1.0f - dir ) ) * 90;
}

void COponentEntity::useBomb( int count )
{
	assert( mBombs > 0 );
	mBombs -= count;
	if( mBombs < 0 ) mBombs = 0;
}