#ifndef __OPONENT_ENTITY_H
#define __OPONENT_ENTITY_H

#include "ItemEntity.h"
#include "../engine/Entity.h"

class COponentEntity : public CEntity {
public:
	COponentEntity();
	
	void update();

	void reset( const D3DXVECTOR3& rezPosition, const D3DXVECTOR3& rezDirection, int bombs, int owned );

	void correctPos( D3DXVECTOR3& pos );

	void orientDirection();

	void useOwned();
	void useBomb( int count );
	
	D3DXVECTOR3 getAttackVelocity();

public:
	D3DXVECTOR3 mDirection;
	D3DXVECTOR3 mUp;

	D3DXVECTOR3 mRezPosition;
	D3DXVECTOR3 mRezDirection;
	float mBombs;
	float mOwned;

	CItemEntity::eType mItem;
};


#endif
