#include "PlayerEntity.h"

#include "MyGame.h"
#include "../engine/camera/BasicCamera.h"
#include "../engine/Terrain.h"
#include "../utils/Random.h"

const float CPlayerEntity::SPEED = 5;

CPlayerEntity::CPlayerEntity( CBasicCamera* camera )
:	mCamera( camera ), mItem( CItemEntity::eType::NONE )
{
}

void CPlayerEntity::update()
{
	D3DXVECTOR3 pos;

	if( mCamera ) {
		//getPosition() = getOldPosition() = mCamera->getPosition();

		//pos = mCamera->getPosition() + mCamera->getFront() * SPEED;
		pos = mCamera->getPosition();
	} else {
		getOldPosition() = getPosition();

		pos = getPosition() + mVelocity;
	}

	//
	// bound to world

	float bound = 30;

	if( pos.x >= gcon::WORLD_X - bound || pos.x < bound ) {
		pos.x = getOldPosition().x;

		pos += D3DXVECTOR3( random::randfs(10.0f), random::randfs(10.0f), 0.0f );
		correctPos( pos );
	}
	if( pos.y >= gcon::WORLD_Y - bound || pos.y < bound ) {
		pos.y = getOldPosition().y;

		pos += D3DXVECTOR3( random::randfs(10.0f), random::randfs(10.0f), 0.0f );
		correctPos( pos );
	}

	pos.z = CMyGame::getInstance().getTerrain().getAltitude( pos.x, pos.y ) + 20;

	if( pos.z + 20 > CMyGame::getInstance().mTerrainTop->getAltitude( pos.x, pos.y ) ) {
		pos = getOldPosition();
		pos += D3DXVECTOR3( random::randfs(10.0f), random::randfs(10.0f), 0.0f );

		correctPos( pos );
	}

	if( mCamera ) {
		getPosition() = getOldPosition() = mCamera->getPosition() = pos;
	
		orientCamera();
	}


	//if( CMyGame::getInstance().mNetClient ) {
		const CSector& s = CMyGame::getInstance().mGrid->getSectorByPosition( getPosition().x, getPosition().y );
					
		if( s.mItem && ( D3DXVec3LengthSq( &( getPosition() - s.mItem->getPosition() ) ) < ( getSize() + s.mItem->getSize() ) * ( getSize() + s.mItem->getSize() ) * 16 ) ) 
		{
			mItem = s.mItem->mType;			
			if( mItem == CItemEntity::eType::UNKNOWN ) mItem = s.mItem->getRandom();
			s.mItem->reset();
		}
	//}

	//if( mItem == CItemEntity::PIG ) setSize( 3.0f );
	//else setSize( 40.0f );
}

void CPlayerEntity::orientCamera() 
{
	assert( mCamera );

	D3DXVECTOR3 pos = mCamera->getPosition();

	float d = 5;

	D3DXVECTOR3 v1( pos.x - d, pos.y, 0 );
	if( v1.x < 0 ) v1.x = 0;
	D3DXVECTOR3 v2( pos.x, pos.y - d, 0 );
	if( v2.y < 0 ) v2.y = 0;

	v1 = D3DXVECTOR3( d, 0,
		CMyGame::getInstance().getTerrain().getAltitude( pos.x, pos.y ) -
		CMyGame::getInstance().getTerrain().getAltitude( v1.x, v1.y ) );

	v2 = D3DXVECTOR3( 0, d,
		CMyGame::getInstance().getTerrain().getAltitude( pos.x, pos.y ) -
		CMyGame::getInstance().getTerrain().getAltitude( v2.x, v2.y ) );

	D3DXVECTOR3 normal;

	D3DXVec3Cross( &normal, &v1, &v2 );
	D3DXVec3Normalize( &normal, &normal );

	float inf = 0.01f;

	D3DXVECTOR3 front = mCamera->getFront();
	//D3DXVECTOR3 up = normal;
	D3DXVECTOR3 up = normal * inf + mCamera->getUp() * ( 1.0f - inf );
	D3DXVECTOR3 right = mCamera->getRight();

	D3DXVec3Cross( &right, &front, &up );		
	//D3DXVec3Cross( &front, &right, &up );
	D3DXVec3Cross( &front, &up, &right );

	D3DXVec3Normalize( &front, &front );
	D3DXVec3Normalize( &up, &up );
	D3DXVec3Normalize( &right, &right );

	mCamera->getFront() = front;
	mCamera->getUp() = up;
	mCamera->getRight() = right;
}

D3DXVECTOR3 CPlayerEntity::getAttackVelocity() {
	assert( mCamera );
	float dir = 0.6f;
	return ( mCamera->getFront() * dir + mCamera->getUp() * ( 1.0f - dir ) ) * 90;
}

void CPlayerEntity::correctPos( D3DXVECTOR3& pos )
{
	float bound = 30;
	if( pos.x >= gcon::WORLD_X - bound || pos.x < bound ) { 
		pos.x = getOldPosition().x;
	}
	if( pos.y >= gcon::WORLD_Y - bound || pos.y < bound ) {
		pos.y = getOldPosition().y;
	}
}

D3DXVECTOR3	CPlayerEntity::getDirection() { return mCamera->getFront(); }