#include "ShootBilboard.h"

#include "MyGame.h"
#include "EngineConstants.h"
#include "BombEntity.h"
#include "DummyEntity.h"

CShootBillboard::CShootBillboard()
:	mPictureId( CResourceId( "" ) ), mLifeTime( -1 )
{
	mDesiredInterPosFinal = 1;
	mDesiredInterPosDelta = 0.1f;
	mDesiredInterPos = 1.1f;
}

CShootBillboard::CShootBillboard( CResourceId pic )
:	mPictureId( pic ), mLifeTime( -1 )
{
}

void CShootBillboard::update()
{
	if( isAlive() ) {
		if( mDesiredInterPos < mDesiredInterPosFinal ) {
			float f = mDesiredInterPos;
			D3DXVECTOR3 pos = mDummyEnity->getPosition() * f + mBombEntity->getPosition() * ( 1.0f - f );
			mVelocity = pos - mPosition;
			mPosition = pos;

			mVelocity *= 0.1f;

			mDesiredInterPos += mDesiredInterPosDelta;
		} else {
			const float inf = 0.3f;
	
			mVelocity = ( mVelocity + D3DXVECTOR3( 0, 0, mGravity ) * inf ) * 0.9f;

			mPosition += mVelocity;

			mColor = mColor & 0x00ffffff + (((int)( ((float)mLifeTime)/mLifeTimeAll * 0xa0 )) << 24 );

			mLifeTime--;
		}
	}
}

void CShootBillboard::reset( float gravity, int lifeTime, float size, D3DCOLOR color, float desiredInterPosFinal, CBombEntity* bombEntity, CDummyEntity* dummyEnity )
//void CShootBillboard::reset( const D3DXVECTOR3& pos, const D3DXVECTOR3& velocity, float gravity, int lifeTime, float size, D3DCOLOR color )
{
	mBombEntity = bombEntity;
	mDummyEnity = dummyEnity;

	mPosition = mBombEntity->getPosition();
	mVelocity = D3DXVECTOR3( 0, 0, 0 );
	mGravity = gravity;
	mLifeTimeAll = mLifeTime = lifeTime;
	mSize = size;
	mColor = color;

	mDesiredInterPosFinal = desiredInterPosFinal;
	mDesiredInterPos = 0;
	mDesiredInterPosDelta = mDesiredInterPosFinal * 0.3;

	//mDesiredInterPosFinal = desiredInterPosFinal;
	//mDesiredInterPosDelta = mDesiredInterPosFinal;
	//mDesiredInterPos = mDesiredInterPosFinal * 0.95;
}

void CShootBillboard::addShoots( CBombEntity* bombEntity, CDummyEntity* dummyEnity )
{
	int count = 15;

	for( int i = 0; i < count; i++ ) {
		CShootBillboard* s = CMyGame::getInstance().nextShoot();

		float gravity = 8;
		if( dummyEnity->mYours ) gravity = -gravity;

		s->reset( gravity, rand() & 31, 3, 0xa0ffffff, ((float)i)/count, bombEntity, dummyEnity );
	}
}