#ifndef __SHOOT_BILBOARD_H
#define __SHOOT_BILBOARD_H

#include <d3dx8math.h>
#include "../engine/resource/ResourceId.h"

class CBombEntity;
class CDummyEntity;

class CShootBillboard {
public:
	CShootBillboard();
	CShootBillboard( CResourceId pic );
	void update();

	void reset( float gravity, int lifeTime, float size, D3DCOLOR color,
		float desiredInterPosFinal, CBombEntity* bombEntity, CDummyEntity* dummyEnity 
	);

	bool isAlive() { return mLifeTime >= 0; }

	static void addShoots( CBombEntity* bombEntity, CDummyEntity* dummyEnity );


public:
	CResourceId		mPictureId;

	D3DXVECTOR3		mPosition;
	D3DXVECTOR3		mVelocity;
	float			mGravity;
	int				mLifeTime;
	int				mLifeTimeAll;
	float			mSize;
	D3DCOLOR		mColor;
	float			mDesiredInterPosFinal;
	float			mDesiredInterPosDelta;
	float			mDesiredInterPos;

	

	CBombEntity* mBombEntity;
	CDummyEntity* mDummyEnity;
};


#endif
