#include "NetClient.h"

#include <iostream>
#include <cassert>
#include "../netlib/Network.h"
#include "../netlib/Commands.h"
#include "../../../engine/console/Console.h"

using namespace std;

CNetClient::CNetClient( const  std::string& server, int port )
:	mTick( 1 ), mGotLastTime( true )
{
	//con::CConsole::getConsole()->openChannel( "net" );
	con::CConsole::getConsole()->getChannel( "net" ) << "initializing" << con::endl;

	srand( timeGetTime() );
	Network::init();
	
	//if( !mNetwork.connect( "127.0.0.1", 7778 ) ) {
	if( !mNetwork.connect( server, port ) ) {
		con::CConsole::getConsole()->getChannel( "net" ) << "Error: cannot connect to server" << con::endl;
		//exit(1);

		mID = 666;

	} else {
		mNetwork.sendReady();

		unsigned long clientCount = 2;
		mID = 0;

		con::CConsole::getConsole()->getChannel( "net" ) << "waiting for second client" << con::endl;
		
		while( !mNetwork.receiveReadyAll( mID, clientCount ) );

		assert( clientCount == 2 );

		con::CConsole::getConsole()->getChannel( "net" ) << "connected" << con::endl;
	}
}

NetData* CNetClient::send( const D3DXVECTOR3& pos, const D3DXVECTOR3& velocity, int bombs, int owned, int itemNum, bool shoot )
{
	if( mGotLastTime ) {
		mData.mPosition = pos;
		mData.mVelocity = velocity;
		mData.mBombs = bombs;
		mData.mOwned = owned;
		mData.mID = mID;
		mData.mItem = itemNum;
		mData.mShot = shoot;
		
		//con::CConsole::getConsole()->getChannel( "net" ) << "sending. tick : " << mTick << con::endl;

		mNetwork.sendTick( mTick, &mData );

		mTick++;

		mHasSent = true;
	} else mHasSent = false;
		
	//con::CConsole::getConsole()->getChannel( "net" ) << "getting" << con::endl;

	unsigned long newTick = mTick, clientCount = 2;
	//while( !mNetwork.receiveTick( newTick, mDataFromNet, clientCount ) );

	mGotLastTime = mNetwork.receiveTick( newTick, mDataFromNet, clientCount );

	if( mGotLastTime ) {
		if( mDataFromNet[0].mID != mID ) return &mDataFromNet[0];
		else return &mDataFromNet[1];
	}

	//con::CConsole::getConsole()->getChannel( "net" ) << "got" << con::endl;

	return NULL;	
}

