#ifndef __NET_CLIENT_H
#define __NET_CLIENT_H

#include <string>
#include <d3dx8math.h>
#include "../netlib/Network.h"
#include "../netlib/Netdata.h"

#define MAXCLIENTS 3

class CNetClient {
public:
	CNetClient( const  std::string& server, int port );
	NetData* send( const D3DXVECTOR3& pos, const D3DXVECTOR3& velocity, int bombs, int owned, int itemNum, bool shoot );

public:
	unsigned long mID;
	bool mHasSent;
	
private:
	Network mNetwork;

	int mTick;
	NetData mData;
	NetData mDataFromNet[MAXCLIENTS];
	bool mGotLastTime;
};

#endif