#include <vector>
#include <iostream>
#include "../netlib/Network.h"
#include "../netlib/Commands.h"
#include <cstdlib>

// #define MINCLIENTS 1


#define CLIENTTIMEOUT 10000

#define TIMEOUTED	1000
#define NONE	0
#define READY   2
		

#define OUTPUT(x) cout << x << endl; 
//#define OUTPUT(x)  


int MINCLIENTS = 1;

using namespace std;

struct client 
{ 
	client(): status( NONE) { lastAccess = timeGetTime();};
	Network net;
	unsigned short status;
	unsigned long tick;

	NetData data;

	DWORD lastAccess;
	bool timeouted()
	{
		return false; //timeGetTime() - lastAccess > CLIENTTIMEOUT;
	}
};

typedef vector< client*> TClients;
TClients clients;

//----------------------------------------------------------
void init();
void waitClients();
void playGame();
void cleanup();

void checkClientsData();
void checkNewClient();
bool allReady();
void checkTicks();
void sendData();
bool allFinished();


Network network;
unsigned long ticks;

//----------------------------------------------------------
int main(int argc, char* argv[])
{
	if ( argc < 2 )
	{
			printf ( "Usage: saerver.exe [min_clients]\n" );
			exit ( 0 );
	}

	MINCLIENTS = atoi ( argv[1] );

	Network::init();
	while( 1) {
		cout << "starting server" << endl;
		init();
		cout << "waiting clients" << endl;
		waitClients();
		cout << "playing game" << endl;
		playGame();
		cout << "end of game" << endl;
		cleanup();
		Sleep( 1000);
	}
	return 0;
}

//----------------------------------------------------------
void init()
{
	if( !network.listen( 7778))
	{
		exit(1);
	}
	network.setTimeout( 0, 1000);
	ticks = 0;
}

//----------------------------------------------------------
void waitClients()
{
	while( (clients.size() < MINCLIENTS) || !allReady())
	{
		checkClientsData();
		checkNewClient();
	}

	int i;
	for( i = 0; i < clients.size(); i ++)
	{
		clients[i]->net.sendReadyAll( i, clients.size());
	}

}

//----------------------------------------------------------
void playGame()
{
	ticks = 1;
	while( !allFinished())
	{
		checkTicks();
		sendData();
		ticks++;
		
	}
}

//----------------------------------------------------------
void cleanup()
{
	network.disconnect();
	for(int i = 0; i < clients.size(); i ++)
	{
		delete clients[i];
	}
	clients.clear();
}

//----------------------------------------------------------
void checkClientsData()
{
	char buffer[ BUFFSIZE];

	TClients::iterator it;

	for( it = clients.begin(); it != clients.end(); ++it)
	{
		if( ((*it)->status != READY) /*&& ( (*it)->net.isConnected())*/)
		{
			if( (*it)->net.receive( buffer, BUFFSIZE) >= 0)
			{
				if( *(int*)buffer == NET_READY)
				{
					(*it)->status = READY;
					OUTPUT( "ready");
				}
				else
				{
					OUTPUT( "not ready");
				}
			}
			else
			{
				OUTPUT( WSAGetLastError());
			}
		}
		
	}
}

//----------------------------------------------------------
void checkNewClient()
{
	int new_fd;
    if( ( new_fd = network.accept()) > 0)
	{
		OUTPUT( "new client");
		client* cl = new client();
		cl->net.setSocket( new_fd);
		clients.push_back( cl);
	}
}

//----------------------------------------------------------
bool allReady()
{
	bool ready = true;

	TClients::iterator it;

	for( it = clients.begin(); it != clients.end(); ++it)
	{
		ready = ready && ((*it)->status == READY);
	}


	return ready;
}

//----------------------------------------------------------
bool allFinished()
{
	bool finish = true;

	TClients::iterator it;

	for( it = clients.begin(); it != clients.end(); ++it)
	{
		finish = finish && ((*it)->status != READY);
	}


	return finish;
}


//----------------------------------------------------------
void checkTicks( )
{
	bool allTicks = false;
	NetData data;
	unsigned long newtick;

	while( !allTicks)
	{
		allTicks = true;
		for (int i = 0; i < clients.size(); i ++)
		{
			if( clients[i]->tick != ticks)
			{
				if( clients[i]->status != TIMEOUTED)
				{
					if( clients[i]->net.receiveTick( newtick, &data, 1))
					{
						OUTPUT( "got: (" << i << ":" << newtick <<")->" << data.foo << "need:" << ticks);
						if ( newtick == ticks)
						{
							clients[i]->tick = newtick;
							clients[i]->data = data;
							clients[i]->lastAccess = timeGetTime();
						}
						else
						{
							allTicks = false;
						}
					}
					else
					{
						allTicks = false;
						if( !clients[i]->net.isConnected())
						{
							//clients[i]->status = TIMEOUTED;
						}
					}
				}

			}
			else
			{
				OUTPUT( "got tick: " << clients[i]->tick << "   need:" << ticks);	
			}
		}
	}
}

//----------------------------------------------------------
void sendData()
{
	char buffer[ BUFFSIZE];
	unsigned long size = 0;
	
	memcpy( buffer + size, &ticks, sizeof(ticks));
	size += sizeof( ticks);

	//cout << "send data: " ;
	int i;
	NetData nd;
	for (i = 0; i < clients.size(); i ++)
	{
		if( clients[i]->status != TIMEOUTED)
		{
			//cout << clients[i]->data.foo << "  (st:" << clients[i]->status << ")  ";
			memcpy( buffer + size, &(clients[i]->data), sizeof( NetData));
			size += sizeof( NetData);
		}
		else 
		{
			//cout << clients[i]->data.foo << "(TO) ";
			memcpy( buffer + size, &nd, sizeof( NetData));
			size += sizeof( NetData);
		}
	}
	//cout << endl;
	//cout << "data size : " << size << endl;

	for (i = 0; i < clients.size(); i ++)
	{
		clients[i]->net.send( buffer, size);
	}

}
