/**
 *  @file engine/TerrainGen.h
 *  Terrain generating utility.
 */

#ifndef __TERRAIN_GEN_H
#define __TERRAIN_GEN_H

#include "resource/ResourceId.h"

class CTerrain;


/**
 *  Terrain generating utilities.
 *  Contain some simple static methods.
 *  @see CTerrain.
 */
class CTerrainGen {
public:
	/**
	 *  Initializes terrain from texture's "red" color.
	 *  @param terrain The terrain.
	 *  @param texID Texture ID.
	 *  @param zMin Altitude for 0.0 in "red" channel.
	 *  @param zMax Altitude for 1.0 in "red" channel.
	 */
	static void fillTexture( CTerrain& terrain, const CResourceId& texID, float zMin = 0.0f, float zMax = 100.0f );
	/**
	 *  Initializes terrain with constant altitude.
	 *  @param terrain The terrain.
	 *  @param z Altitude.
	 */
	static void fillConst( CTerrain& terrain, float z );
	/**
	 *  Completely randomizes the terrain.
	 *  @param terrain The terrain.
	 *  @param zMin Minimum altitude.
	 *  @param zMax Maximum altitude.
	 */
	static void fillRandom( CTerrain& terrain, float zMin, float zMax );

	/**
	 *  Raises whole terrain by fixed amount.
	 *  @param terrain The terrain.
	 *  @param z Altitude to raise by.
	 */
	static void addConst( CTerrain& terrain, float z );
};


#endif
