/**
 *  @file engine/TerrainPicker.h
 *  Terrain pick utility.
 */
#ifndef __TERRAIN_PICKER_H
#define __TERRAIN_PICKER_H

#include <d3dx8math.h>

class CTerrain;
class CCamera;

/**
 *  Terrain pick result.
 *  Contains location of pick and nearest terrain cell indices.
 */
struct CTerrainPick {
public:
	CTerrainPick()
		: mCellX(-1), mCellY(-1) { }
	CTerrainPick( const D3DXVECTOR3& location, int cellX, int cellY )
		: mLocation(location), mCellX(cellX), mCellY(cellY) { }

	/// Is the pick valid?
	bool isValid() const { return (mCellX >= 0 && mCellY >= 0); }
	/// Gets location of the intersection.
	const D3DXVECTOR3& getLocation() const { return mLocation; }
	/// Gets nearest terrain cell X index.
	int	getCellX() const { return mCellX; }
	/// Gets nearest terrain cell Y index.
	int	getCellY() const { return mCellY; }
	
private:
	D3DXVECTOR3	mLocation;
	int			mCellX;
	int			mCellY;
};


/**
 *  A utility to pick terrain.
 *  Pick result is the intersection of some world space ray and terrain.
 *  @see CTerrainPick.
 */
class CTerrainPicker {
public:
	/**
	 *  Intersect a ray and a terrain.
	 */
	static CTerrainPick pick( const CTerrain& terrain, const D3DXVECTOR3& origin, const D3DXVECTOR3& dir );
private:
	static CTerrainPick mNoPick;
};


#endif
