#pragma warning( disable:4786 )
#include "TextureBundle.h"

#include <cassert>
#include "../../utils/Errors.h"


CTextureBundle::CTextureBundle( IDirect3DDevice8& device, std::string predir )
:	mDevice( device ),
	mPreDir( predir )
{
}

CTextureBundle::~CTextureBundle()
{
	// HACK: in order to clear resources
	clear();
	CONSOLE.write( "texture bundle destroyed" );
}

IDirect3DTexture8* CTextureBundle::loadResourceById( CResourceId const& id )
{
	IDirect3DTexture8* texture = NULL;

	// NOTE: by default created texture must be placed to D3DPOOL_MANAGED
	// so probably following code is not needed

	HRESULT hres = D3DXCreateTextureFromFileExA(
		&mDevice,
		( mPreDir + id.getUniqueName() ).c_str(),
		D3DX_DEFAULT, D3DX_DEFAULT,
		0,	// mipLevels
		0,
		D3DFMT_UNKNOWN,
		D3DPOOL_MANAGED,
		D3DX_DEFAULT,
		D3DX_DEFAULT,
		0,
		NULL,
		NULL,
		&texture
	);
	
	if( !SUCCEEDED( hres ) ) {
		THROW_DXERROR( hres, "failed to load texture '" + id.getUniqueName() + "'" );
	}
	assert( texture );

	CONSOLE.write( "texture loaded '" + id.getUniqueName() + "'" );

	return texture;
}

void CTextureBundle::touchResource( IDirect3DTexture8& resource )
{
	resource.AddRef();
}

void CTextureBundle::clearResource( IDirect3DTexture8& resource )
{
	// DEBUG
	ULONG i = resource.Release();
}
