/**
 *  @file engine/resource/TextureBundle.h
 *  Texture bundle.
 */
#pragma warning( disable:4786 )
#ifndef __TEXTURE_BUNDLE_H
#define __TEXTURE_BUNDLE_H

#include "BundleSingleton.h"
#include "StorageResourceBundle.h"


/**
 *  Texture bundle.
 *  Texture loading and shared access happens here. It's a singleton via
 *  static getInstance() method.
 *  @see CResourceId, IResourceBundle#getResourceById, IResourceBundle#rejectResource, IResourceBundle#clear.
 */
class CTextureBundle : public CStorageResourceBundle<IDirect3DTexture8>, public CBundleSingleton<CTextureBundle>
{
public:
	static void init( IDirect3DDevice8& device, std::string predir = "" ) {
		CTextureBundle* bundle = new CTextureBundle( device, predir );
		assert( bundle );
		assignInstance( *bundle );
	}

	const std::string& getPreDir() const { return mPreDir; }
	IDirect3DDevice8& getDevice() { return mDevice; }

protected:
	virtual IDirect3DTexture8* loadResourceById( CResourceId const& id );
	virtual void touchResource( IDirect3DTexture8& resource );
	virtual void clearResource( IDirect3DTexture8& resource );
	
private:
	CTextureBundle( IDirect3DDevice8& device, std::string predir = "" );
	virtual ~CTextureBundle();
	friend CBundleSingleton<CTextureBundle>;

private:
	std::string const	mPreDir;
	IDirect3DDevice8&	mDevice;
};

#endif
