#pragma warning( disable:4786 )
#include "Missile.h"

#include "MyGame.h"
#include "../engine/Terrain.h"
#include "../engine/EntityRenderer.h"
#include "../engine/resource/PictureBundle.h"
#include "../utils/Random.h"


// ENGINE CONSTANTS
#include "EngineConstants.h"


void CMissile::init( eType type )
{
	mFlags = type & F_TYPEMASK;
	if( type != T_BULLET )
		mFlags |= F_GRAVITY;

	CResourceId rid;

	switch( type ) {
	case T_BULLET:
		rid = CResourceId( "MisBullet.png" );
		setSize( 1.0f );
		break;
	case T_BALL:
		rid = CResourceId( "MisBall.png" );
		setSize( 5.0f );
		break;
	case T_FIREBALL:
		rid = CResourceId( "MisFireBall.png" );
		setSize( 8.0f );
		break;
	case T_GROUND:
		rid = CResourceId( "MisGround.png" );
		setSize( 12.0f );
		break;
	case T_WARRIOR:
		rid = CResourceId( "MisWarrior.png" );
		setSize( 8.0f );
		break;
	case T_FIRESTARTER:
		rid = CResourceId( "MisFirestarter.png" );
		setSize( 10.0f );
		break;
	case T_PROPHET:
		rid = CResourceId( "MisProphet.png" );
		setSize( 20.0f );
		break;
	}

	getOldPosition() = getPosition();
	
	int cc = 255 - (rand()&63);
	setColor( D3DCOLOR_XRGB(cc,cc,cc) );
	setPicture( *CPictureBundle::getInstance().getResourceById( rid ) );
}

void CMissile::update()
{
	if( mFlags & F_FLYING )
		updateFlying();
	else
		updateWalking();
}

void CMissile::updateFlying()
{
	getOldPosition() = getPosition();

	D3DXVECTOR3 pos = getPosition() + mVelocity;

	// check world bounds
	if( pos.x >= gcon::WORLD_X || pos.x < 0.0f || pos.y >= gcon::WORLD_Y || pos.y < 0.0f ) {
		mFlags |= F_KILLED;
		return;
	}

	CMyGame& game = CMyGame::getInstance();

	// gravity
	if( mFlags & F_GRAVITY )
		mVelocity.z -= gcon::GRAVITY*2.0f;

	// hit the ground?
	float h = game.getTerrain().getAltitude( pos.x, pos.y ) + getSize();
	if( pos.z < h ) {
		pos.z = h;
		getOldPosition().z = h;
		mFlags &= ~F_FLYING;
		
		SMissileSector& sMis = game.mMissileGrid.getSectorByPosition( pos.x, pos.y );
	}

		//
		// spread things
		
		SForestSector& s = game.mForestGrid.getSectorByPosition( pos.x, pos.y );
		if( mFlags & F_LUMBERJACK ) {
			/*
			// spawn lumberjacks
			for( int i = 0; i < mAmount; ++i ) {
				if( !game.hasSpace() || game.mLumberjacks->size() >= game.mLumberjacks->capacity() )
					break;
				CLumberjack& e = game.mLumberjacks->add();
				game.getEntities().add( e );
				e.getPosition().x = pos.x + random::randfs(mSpread);
				e.getPosition().y = pos.y + random::randfs(mSpread);
				if( e.getPosition().x < 0.0f ) e.getPosition().x = 0.0f;
				else if( e.getPosition().x >= gcon::WORLD_X ) e.getPosition().x = gcon::WORLD_X-gcon::EPSILON;
				if( e.getPosition().y < 0.0f ) e.getPosition().y = 0.0f;
				else if( e.getPosition().y >= gcon::WORLD_Y ) e.getPosition().y = gcon::WORLD_Y-gcon::EPSILON;
				e.init( *(CVillage*)NULL, 100 );
			}
		*/
		} else if( mFlags & F_FIRE ) {
			s.mBurningAmount += mAmount;
		} else if( mFlags & F_DISEASE ) {
			s.mDiseaseAmount += mAmount;
		}
		mFlags |= F_KILLED;
	}

	getPosition() = pos;
}

void CMissile::updateFlying()
{
	CMyGame& game = CMyGame::getInstance();

	// set old position

	getOldPosition() = getPosition();


	// get additional velocity from slope
	
	D3DXVECTOR3 pos = getPosition() + mVelocity;

	//
	// bound to world

	if( pos.x >= gcon::WORLD_X || pos.x < 0.0f ) {
		mVelocity.x = -mVelocity.x;
		pos.x = getOldPosition().x;
	}
	if( pos.y >= gcon::WORLD_Y || pos.y < 0.0f ) {
		mVelocity.y = -mVelocity.y;
		pos.y = getOldPosition().y;
	}

	//
	// terrain height

	float h = game.getTerrain().getAltitude( pos.x, pos.y ) + getSize();

	mVelocity.x *= 0.92f;
	mVelocity.y *= 0.92f;
	mVelocity.z -= gcon::GRAVITY*4.0f;
	if( pos.z < h ) {
		pos.z = h;
		getOldPosition().z = h;
		mVelocity.z = 0.0f;

		//
		// spread things
		
		SForestSector& s = game.mForestGrid.getSectorByPosition( pos.x, pos.y );
		if( mFlags & F_LUMBERJACK ) {
			/*
			// spawn lumberjacks
			for( int i = 0; i < mAmount; ++i ) {
				if( !game.hasSpace() || game.mLumberjacks->size() >= game.mLumberjacks->capacity() )
					break;
				CLumberjack& e = game.mLumberjacks->add();
				game.getEntities().add( e );
				e.getPosition().x = pos.x + random::randfs(mSpread);
				e.getPosition().y = pos.y + random::randfs(mSpread);
				if( e.getPosition().x < 0.0f ) e.getPosition().x = 0.0f;
				else if( e.getPosition().x >= gcon::WORLD_X ) e.getPosition().x = gcon::WORLD_X-gcon::EPSILON;
				if( e.getPosition().y < 0.0f ) e.getPosition().y = 0.0f;
				else if( e.getPosition().y >= gcon::WORLD_Y ) e.getPosition().y = gcon::WORLD_Y-gcon::EPSILON;
				e.init( *(CVillage*)NULL, 100 );
			}
		*/
		} else if( mFlags & F_FIRE ) {
			s.mBurningAmount += mAmount;
		} else if( mFlags & F_DISEASE ) {
			s.mDiseaseAmount += mAmount;
		}
		mFlags |= F_KILLED;
	}

	getPosition() = pos;
}
