
#ifndef __CARGO_H
#define __CARGO_H

#include <d3dx8math.h>

#include "../engine/Entity.h"


#pragma pack(1)

class CMissile : public CEntity {
public:
	enum {
		F_KILLED = 8,
		F_GRAVITY = 16,
		F_FLYING = 32
	};
	enum eType {
		T_BULLET = 0,
		T_BALL = 1,
		T_FIREBALL = 2,
		T_GROUND = 3,
		T_WARRIOR = 4,
		T_FIRESTARTER = 5,
		T_PROPHET = 6,
		F_TYPEMASK = 7
	};
	
public:
	void	init( eType type );

	void	update();

private:
	void	updateFlying();
	void	updateWalking();
	
public:
	D3DXVECTOR3		mVelocity;
	short			mFlags;
	short			mTTL;
};

#pragma pack()

#endif
