#include "MyEntity.h"

#include "MyGame.h"
#include "../engine/Terrain.h"


// ENGINE CONSTANTS
#include "EngineConstants.h"

void CMyEntity::init()
{
	mVelocity.x = mVelocity.y = mVelocity.z = 0;
	mFlags = 0;
	//mLeader = NULL;
	mCounter = 0;
	//int pref = rand() % (CGoods::MAX_GOODS-1) + 1;
	//mPreference = (CGoods::eGoods)pref;
	//++CMyGame::getInstance().mLeft[pref];
}

void CMyEntity::update()
{
	//
	// set old position

	getOldPosition() = getPosition();


	if( mFlags & F_READY_TO_DIE ) {
		++mCounter;
		if( mCounter > DIE_TIME )
			mFlags |= F_KILLED;
		mVelocity.x *= 0.95f;
		mVelocity.y *= 0.95f;
		mVelocity.z += gcon::GRAVITY * 2.0f;
		getPosition() += mVelocity;
		return;
	}

	/*
	if( mLeader ) {
		// follow leader
		float dx = getPosition().x - mLeader->getPosition().x;
		float dy = getPosition().y - mLeader->getPosition().y;
		if( dx*dx + dy*dy < 400.0f ) {
			mFlags |= F_READY_TO_DIE;
			mCounter = 0;
			setColor( 0xFF8080FF );
			if( mLeader->isEvil() )
				++CMyGame::getInstance().mScoreEvil;
			else
				++CMyGame::getInstance().mScoreGood;
			--CMyGame::getInstance().mLeft[ mPreference ];
		} else {
			static int fakeCounter = 0;
			++fakeCounter;
			if( fakeCounter > 11 ) {
				D3DXVECTOR2 vec( dx, dy );
				D3DXVec2Normalize( &vec, &vec );
				mVelocity.x = mVelocity.x * 0.75f - vec.x * 0.3f;
				mVelocity.y = mVelocity.y * 0.75f - vec.y * 0.3f;
			}
		}
		++mCounter;
		if( mCounter > READY_TIME ) {
			mCounter = 0;
			mLeader = NULL;
			setColor( 0xFFFFFFFF );
		}
	} else*/ {
		// get additional velocity from slope
		D3DXVECTOR3 vel = mVelocity;
		float dx, dy;
		CMyGame::getInstance().getTerrain().getSlope( getPosition().x, getPosition().y, dx, dy );

		mVelocity.x -= dx;
		mVelocity.y -= dy;

		mVelocity *= 0.99f;
	}

	// check leader
	/*
	SPoliticalSector& s = CMyGame::getInstance().mPoliticalGrid.getSectorByPosition( getPosition().x, getPosition().y );
	if( s.mPromise && s.mPromise->getGoods() == mPreference ) {
		if( mLeader != &s.mPromise->getPolitician() )
			mVelocity.z += gcon::GRAVITY * 20.0f;
		mLeader = &s.mPromise->getPolitician();
		setColor( mLeader->isEvil() ? 0xFFFF9090 : 0xFF90FF90 );
	}
	*/
	
	D3DXVECTOR3 pos = getPosition() + mVelocity;


	//
	// bound to world

	if( pos.x >= gcon::WORLD_X || pos.x < 0.0f ) {
		mVelocity.x = -mVelocity.x;
		pos.x = getOldPosition().x;
	}
	if( pos.y >= gcon::WORLD_Y || pos.y < 0.0f ) {
		mVelocity.y = -mVelocity.y;
		pos.y = getOldPosition().y;
	}


	//
	// terrain height

	float h = CMyGame::getInstance().getTerrain().getAltitude( pos.x, pos.y ) + getSize();

	mVelocity.z -= gcon::GRAVITY*2.0f;
	if( pos.z < h ) {
		pos.z = h;
		getOldPosition().z = h;
		mVelocity.z = 0.0f; // TODO: bounce off?
	}

	getPosition() = pos;
}
