#pragma warning(disable:4786)

#include "MyGame.h"
#include "../engine/EntityRenderer.h"
#include "../engine/Mesh.h"
#include "../engine/Terrain.h"
#include "../engine/TerrainGen.h"
#include "../engine/camera/BasicCamera.h"
#include "../engine/resource/PictureBundle.h"

// ENGINE CONSTANTS
#include "EngineConstants.h"
#include "../utils/Random.h"

#include "../engine/TerrainPicker.h"
#include "../engine/TextRenderer.h"
#include "../engine/Billboarder.h"
#include "TerrainModifier.h"
#include "../utils/Config.h"

#include <cassert>


//const int TURN_TIME = (gcon::UPDATE_FREQ) * 40;

// ------------------------------------------------------------------
//  basic stuff


CMyGame::CMyGame( CConfig& config )
:	CBaseGame( config ),
	mTerrainCamera( NULL ),
	mLumberjacks( NULL ),
	mTrees( NULL )//,
	//mCargo( NULL )
{
}

CMyGame::~CMyGame()
{
	delete mLumberjacks;
	delete mTrees;
	//delete mCargo;
}

static void resetCamera( CBasicCamera& camera )
{
	camera.reset();
	camera.setProjectionParams( 3.1415927f * 0.33f, 0.7f, 10.0f, gcon::WORLD_X*1.6f );
	camera.getPosition() = D3DXVECTOR3( gcon::WORLD_X * 0.5f, gcon::WORLD_Y * 0.3f, 350.0f );
	camera.setBounded( true );
	//camera.doPitch( -1.0f );
	//camera.update( CFrameTime( 1.0f, 1.0f, 1, 0.1f ) );
	camera.stop();
}


CCamera* CMyGame::createCamera()
{
	mTowerMeshes[0] = new CMesh( CResourceId( "cylinder10atzero.x" ), CResourceId( "TexturedMesh.sha" ), CResourceId( "TerrainGray.png" ) );
	getObjects().addObject( *mTowerMeshes[0] );
	mTowerMeshes[1] = new CMesh( CResourceId( "cylinder10atzero.x" ), CResourceId( "TexturedMesh.sha" ), CResourceId( "TerrainGray.png" ) );
	getObjects().addObject( *mTowerMeshes[1] );

	mTerrainCamera = new CBasicCamera();
	return mTerrainCamera;
}



// ------------------------------------------------------------------
//  input


void CMyGame::onMouseLChange( bool pressed )
{
}

void CMyGame::onMouseRChange( bool pressed )
{
}

void CMyGame::onKeyChange( int key, bool pressed )
{
	if( pressed ) {
		switch( key ) {
		//case '1': mActiveGoods = CGoods::MONEY; break;
		//case '2': mActiveGoods = CGoods::JOBS; break;
		//case '3': mActiveGoods = CGoods::GAMES; break;
		//case '4': mActiveGoods = CGoods::FOOD; break;
		case ' ':
			//if( mLumberjacks->size() < mPromises->capacity() )
			//	restartGame();
			if( mIntro )
				mIntro = false;
			//else
			//	mTurnPause = false;
			break;
		}
	}
}

void CMyGame::onProcessInput( const CFrameTime& frameTime )
{
	assert( mTerrainCamera );
	CBasicCamera& cam = *mTerrainCamera;
	const CKeyboard& key = getKeyboard();

	float dt = frameTime.getDelta();

	switch( mControlMode ) {
	case TOWER:
		cam.setTurnDamping( 5.0f );
		if( key.isKeyPressed(VK_LEFT) )		cam.doYaw( 4.5f * dt );
		if( key.isKeyPressed(VK_RIGHT) )	cam.doYaw( -4.5f * dt );
		if( key.isKeyPressed(VK_UP) )		cam.doPitch( 2.5f * dt );
		if( key.isKeyPressed(VK_DOWN) )		cam.doPitch( -2.5f * dt );
		break;
	default:
		if( getKeyboard().isKeyPressed(VK_LEFT) )	mTerrainCamera->doYaw( 2.0f * dt );
		if( getKeyboard().isKeyPressed(VK_RIGHT) )	mTerrainCamera->doYaw( -2.0f * dt );
		if( getKeyboard().isKeyPressed('S') )		mTerrainCamera->doMove( 1800.0f * dt );
		if( getKeyboard().isKeyPressed('X') )		mTerrainCamera->doMove( -1800.0f * dt );
		if( getKeyboard().isKeyPressed('A') )		mTerrainCamera->doStrafe( -1200.0f * dt );
		if( getKeyboard().isKeyPressed('D') )		mTerrainCamera->doStrafe( 1200.0f * dt );
		if( getKeyboard().isKeyPressed(VK_UP) )		mTerrainCamera->doPitch( 1.5f * dt );
		if( getKeyboard().isKeyPressed(VK_DOWN) )	mTerrainCamera->doPitch( -1.5f * dt );
		if( getKeyboard().isKeyPressed('Q') )		mTerrainCamera->doRise( 1500.0f * dt );
		if( getKeyboard().isKeyPressed('W') )		mTerrainCamera->doRise( -1500.0f * dt );
	}
}


// ------------------------------------------------------------------
//  initialization


void CMyGame::onInitialize()
{
	mIntro = true;
	/*
	mTotalTurns = getConfig().readI( "game", "turns", 10 );

	int n = getConfig().readI( "game", "politicians", 10 );
	mPoliticians = new TPolitPool( n*2 );
	*/
	
	mTerrainCamera->setTerrain( getTerrain() );

	int maxEntities = getEntities().getMaxEntities();
	mLumberjacks = new TLumberjackPool( 200 );

	mTrees = new TTreePool( maxEntities/2 );

	//mCargo = new TCargoPool( 100 );

	mVillages = new TVillagePool( 100 );
	
	CTerrainGen::fillTexture( getTerrain(), CResourceId("TerrainGray.png"), -50.0f, 100.0f );

	restartGame();
}


void CMyGame::restartGame()
{
	// towers
	mTowers[0].init( 50.0f, 50.0f, 40.0f );
	mTowers[0].mHeight = 100.0f;
	mTowers[1].init( gcon::WORLD_X-50.0f, gcon::WORLD_X-50.0f, 40.0f );
	mTowers[1].mHeight = 100.0f;

	mControlMode = TOWER;
	
	// remove all old
	TTreePool::iterator trit;
	for( trit = mTrees->begin(); trit != mTrees->end(); ) {
		CTreeEntity& e = *trit;
		getEntities().remove( e );
		trit = mTrees->erase( trit );
	}
	TLumberjackPool::iterator it;
	for( it = mLumberjacks->begin(); it != mLumberjacks->end();  ) {
		CLumberjack& e = *it;
		getEntities().remove( e );
		it = mLumberjacks->erase( it );
	}
	/*
	TCargoPool::iterator cit;
	for( cit = mCargo->begin(); cit != mCargo->end();  ) {
		CCargo& e = *cit;
		getEntities().remove( e );
		cit = mCargo->erase( cit );
	}
	*/
	
	int i;
	
	resetCamera( *mTerrainCamera );
	
	CPictureBundle& pb = CPictureBundle::getInstance();
	
	for( i = 0; i < 5; ++i ) {
		CVillage& v = mVillages->add();
		float x, y, z;
		do {
			x = random::randf( gcon::WORLD_X );
			y = random::randf( gcon::WORLD_Y );
			z = getTerrain().getAltitude( x, y );
		} while( z <= 5.0f );
		v.init( x, y, 30.0f, 100, 1000 );
	}

	for( i = 0; i < mLumberjacks->capacity()/2; ++i ) {
		CLumberjack& e = mLumberjacks->add();
		getEntities().add( e );
		e.getPosition().x = random::randf(gcon::WORLD_X);
		e.getPosition().y = random::randf(gcon::WORLD_Y);
		int vil = rand() % mVillages->size();
		TVillagePool::iterator it = mVillages->begin();
		while( vil > 0 ) {
			--vil;
			++it;
		}
		e.init( *it, 100 );
	}

	/*
	for( i = 0; i < mCargo->capacity(); ++i ) {
		CCargo& e = mCargo->add();
		getEntities().add( e );
		e.getPosition().x = random::randf(gcon::WORLD_X);
		e.getPosition().y = random::randf(gcon::WORLD_Y);
		e.getPosition().z = getTerrain().getMaxAltitude() + 150.0f;
		e.mVelocity.x = random::randfs(10.0f);
		e.mVelocity.y = random::randfs(10.0f);
		e.mVelocity.z = 0.0f;
		e.mAmount = 5;
		e.mSpread = 30.0f;
		e.mFlags = CCargo::F_LUMBERJACK;
		e.init();
	}
	*/
	
	for( i = 0; i < mTrees->capacity(); ++i ) {
		CTreeEntity& e = mTrees->add();
		getEntities().add( e );
		e.getPosition().x = random::randf(gcon::WORLD_X);
		e.getPosition().y = random::randf(gcon::WORLD_Y);
		e.init();
	}
}


// ------------------------------------------------------------------
//  game logic

bool CMyGame::hasSpace() const
{
	return getEntities().getEntityCount() < getEntities().getMaxEntities();
}

void CMyGame::onUpdate()
{
	manageCameraUpdate();

	//
	// tower meshes

	for( int t = 0; t < NUM_TOWERS; ++t ) {
		D3DXMATRIX& m = mTowerMeshes[t]->getWorldMatrix();
		m._11 = mTowers[t].getSize() / 10.0f;
		m._22 = mTowers[t].getSize() / 10.0f;
		m._33 = mTowers[t].mHeight / 10.0f;
		m._41 = mTowers[t].getX();
		m._42 = mTowers[t].getY();
		m._43 = getTerrain().getAltitude( m._41, m._42 ) - 5.0f;
	}

	//
	// clear grids

	mForestGrid.beginFrame();

	/*
	if( mTurnPause ) {
		// update polits
		TPolitPool::iterator pit;
		for( pit = mPoliticians->begin(); pit != mPoliticians->end(); ++pit ) {
			CTreeEntity& e = *pit;
			e.getOldPosition() = e.getPosition();
		}
		// update promises
		TPromisePool::iterator prit;
		for( prit = mPromises->begin(); prit != mPromises->end(); ++prit ) {
			CPromise& e = *prit;
			e.getOldPosition() = e.getPosition();
		}
		// update entities
		TLumberjackPool::iterator it;
		for( it = mLumberjacks->begin(); it != mLumberjacks->end(); ++it ) {
			CLumberjack& e = *it;
			e.getOldPosition() = e.getPosition();
		}
		return;
	}
	*/

	// attractor/protractor
	const CMouse& m = getMouse();
	if( m.isMouseLPressed() || m.isMouseRPressed() ) {
		D3DXVECTOR3 origin = getCamera().getPosition();
		D3DXVECTOR3 dir = getCamera().getWorldRay( m.getMouseX(), m.getMouseY() );
		CTerrainPick pick = CTerrainPicker::pick( getTerrain(), origin, dir );
		if( pick.isValid() ) {
			CTerrainModifier::raise( getTerrain(), pick.getLocation().x, pick.getLocation().y, 100.0f, m.isMouseLPressed() ? 20.0f : -20.0f );
			/*
			if( m.isMouseLPressed() ) {
				mAttractor.mX = pick.getLocation().x;
				mAttractor.mY = pick.getLocation().y;
				mAttractor.mActive = true;
			} else {
				mProtractor.mX = pick.getLocation().x;
				mProtractor.mY = pick.getLocation().y;
				mProtractor.mActive = true;
			}
			*/
		}
	}
	
	/*
	// change politician
	const CMouse& m = getMouse();
	if( m.isMouseLPressed() ) {
		if( !mJustChangedPolitician ) {
			mRay.mHasRay = true;
			mRay.mOrigin = getCamera().getPosition();
			D3DXVECTOR3 dir = getCamera().getWorldRay( m.getMouseX(), m.getMouseY() );
			D3DXVec3Normalize( &mRay.mDirection, &dir );
		}
	} else {
		mJustChangedPolitician = false;
	}
	*/
	

	/*
	// update cargo
	TCargoPool::iterator cit;
	for( cit = mCargo->begin(); cit != mCargo->end();  ) {
		CCargo& e = *cit;
		e.update();
		if( e.mFlags & CCargo::F_KILLED ) {
			cit = mCargo->erase( cit );
			getEntities().remove( e );
		} else {
			++cit;
		}
	}
	*/

	// update lumberjacks
	TLumberjackPool::iterator lit;
	for( lit = mLumberjacks->begin(); lit != mLumberjacks->end();  ) {
		CLumberjack& e = *lit;
		e.update();
		if( e.mFlags & CLumberjack::F_KILLED ) {
			lit = mLumberjacks->erase( lit );
			getEntities().remove( e );
		} else {
			++lit;
		}
	}

	// update trees
	TTreePool::iterator tit;
	for( tit = mTrees->begin(); tit != mTrees->end();  ) {
		CTreeEntity& e = *tit;
		e.update();
		if( e.mFlags & CTreeEntity::F_KILLED ) {
			tit = mTrees->erase( tit );
			getEntities().remove( e );
		} else {
			++tit;
		}
	}
}

void CMyGame::manageCameraUpdate()
{
	CBasicCamera& cam = *mTerrainCamera;
	
	switch( mControlMode ) {
	case TOWER:
		cam.getPosition().x = mTowers[mMyTower].getX();
		cam.getPosition().y = mTowers[mMyTower].getY();
		cam.getPosition().z = mTowerMeshes[mMyTower]->getWorldMatrix()._43 + mTowers[mMyTower].mHeight + 20.0f;
		if( mMyTower == 0 ) {
			float x = cam.getCameraMatrix()._31;
			if( x <= 0.0f )
				cam.doYaw( x*1.2f );
			float y = cam.getCameraMatrix()._32;
			if( y <= 0.0f )
				cam.doYaw( -y*1.2f );
			float z = cam.getCameraMatrix()._33;
			if( z <= -0.5f || z >= 0.5f ) {
				cam.doPitch( -z*1.2f );
			}
		} else {
		}
		break;
	}
}


// ------------------------------------------------------------------
//  rendering

void CMyGame::onRenderBeforeAll()
{
	CBillboarder& bb = getBillboarder();
	bb.beginBillboards();

	/*
	if( mAttractor.mActive ) {
		float x = mAttractor.mX;
		float y = mAttractor.mY;
		float z = getTerrain().getAltitude( x, y ) + 10.0f;
		bb.putWorldBill( CResourceId("Attractor.png"), 0xC0FFFFFF, D3DXVECTOR3(x,y,z), 60.0f, 60.0f );
	}
	if( mProtractor.mActive ) {
		float x = mProtractor.mX;
		float y = mProtractor.mY;
		float z = getTerrain().getAltitude( x, y ) + 10.0f;
		bb.putWorldBill( CResourceId("Protractor.png"), 0xC0FFFFFF, D3DXVECTOR3(x,y,z), 60.0f, 60.0f );
	}
	*/
	/*
	int n = mPoliticians->capacity()/2;

	// politicians
	TPolitPool::iterator pit;
	for( pit = mPoliticians->begin(); pit != mPoliticians->end(); ++pit ) {
		CTreeEntity& e = *pit;
		const CResourceId* rid = CGoods::getResource( e.getGoods() );
		if( rid ) {
			bb.putEntityBill( *rid, 0xC0FFFFFF, e, 20, 20 );
		}
	}

	if( mLumberjacks->size() < mPromises->capacity() ) {
		if( mScoreEvil > mScoreGood ) {
			bb.putScreenBill( CResourceId("Politician1big.png"), 0xD0FFFFFF, -0.6f, -0.8f, 0.6f, 0.8f );
		} else if( mScoreGood > mScoreEvil ) {
			bb.putScreenBill( CResourceId("Politician2big.png"), 0xD0FFFFFF, -0.6f, -0.8f, 0.6f, 0.8f );
		} else {
			bb.putScreenBill( CResourceId("Politician1big.png"), 0xD0FFFFFF, -0.8f, -0.6f, -0.1f, 0.6f );
			bb.putScreenBill( CResourceId("Politician2big.png"), 0xD0FFFFFF, 0.1f, -0.6f, 0.8f, 0.6f );
		}
		bb.putScreenBill( CResourceId("PressSpace.png"), 0xF0FFFFFF, -0.4f, 0.71f, 0.4f, 0.93f );
	} else if( !mIntro ) {
		// indicators
		static CResourceId barid( "Bar.png" );

		if( !mTurnPause ) {
			float xx = ((float)mTurnCounter / TURN_TIME) * 2.0f - 1.0f;
			bb.putScreenBill( barid, 0xC0FFFF20, -1.0f, 0.95f, xx, 0.99f );
		}
		float yy1 = 0.99f - ((float)mScoreEvil / mLumberjacks->capacity()) * 2.0f;
		bb.putScreenBill( barid, 0xC0FF4040, -0.95f, yy1, -0.9f, 0.99f );
		float yy2 = 0.99f - ((float)mScoreGood / mLumberjacks->capacity()) * 2.0f;
		bb.putScreenBill( barid, 0xC040FF40, 0.9f, yy2, 0.95f, 0.99f );

		if( mEvilTurn ) {
			bb.putScreenBill( CResourceId("Politician1big.png"), 0xA0FFFFFF, -0.85f, 0.43f, -0.55f, 0.85f );
		} else {
			bb.putScreenBill( CResourceId("Politician2big.png"), 0xA0FFFFFF, 0.55f, 0.43f, 0.85f, 0.85f );
		}
		
		// active goods
		const CResourceId* rid = CGoods::getResource( mActiveGoods );
		if( rid ) {
			bb.putScreenBill( *rid, 0xD0FFFFFF, -0.14f, 0.69f, 0.14f, 0.99f );
		}

		if( mTurnPause ) {
			DWORD color = mEvilTurn ? 0xF0FFA0A0 : 0xF0A0FFA0;
			bb.putScreenBill( CResourceId("PressSpace.png"), color, -0.4f, -0.11f, 0.4f, 0.11f );
		}

		// left preferences
		for( int i = 1; i < CGoods::MAX_GOODS; ++i ) {
			float yy = -0.9f + i*0.2f;
			bb.putScreenBill( *CGoods::getResource2( (CGoods::eGoods)i ), 0xC0FFFFFF, 0.82f, yy-0.08f, 0.96f, yy+0.08f );
			float xx = 0.84f - ((float)mLeft[i] / mLumberjacks->capacity()) * 0.5f;
			bb.putScreenBill( barid, 0xC0FFFFFF, xx, yy-0.01f, 0.84f, yy+0.03f );
		}
	} else {
	*/ if( mIntro ) {
		//bb.putScreenBill( CResourceId("PressSpace.png"), 0xF0FFFFFF, -0.4f, 0.71f, 0.4f, 0.93f );
	}

	
	bb.endBillboards();
}

void CMyGame::onRenderAfterWorld()
{
}

void CMyGame::onRenderAfterAll()
{
	char buf[100];
	sprintf( buf, "Entities: %i, Trees: %i", getEntities().getEntityCount(), mTrees->size() );
	getTextRenderer().renderScreenText( 4, 18, buf, 0x80FFFF00 );
	
	/*
	if( mLumberjacks->size() < mPromises->capacity() ) {
	} else if( !mIntro ) {
		sprintf( buf, "Entities: %i", getEntities().getEntityCount() );
		getTextRenderer().renderScreenText( 4, 18, buf, 0x80FFFF00 );

		getTextRenderer().renderScreenText( 4, 32, "1234 - change active goods", 0x80FFFF00 );

		sprintf( buf, "The %s win by %i", mScoreEvil>mScoreGood?"reds":"greens", abs(mScoreEvil-mScoreGood) );

		getTextRenderer().renderScreenText( 10, 50, buf, mScoreEvil>mScoreGood ? 0xC0FF8080 : 0xC080FF80 );
	} else*/ if( mIntro ) {
		/*
		getTextRenderer().renderScreenText( 20, 50,
			"GameJam'02 - Politics for the Masses game by NeARAZ", 0xD0FF4040 );
		getTextRenderer().renderScreenText( 20, 70,
			"This is a two player turn-based game. The players play for red or green party.\n"
			"Each party has some politicians, and can offer/promise various things to the\n"
			"masses. You do this by selecting the thing with 1/2/3/4, and clicking on your\n"
			"politician.", 0xD0FFFFFF );
		getTextRenderer().renderScreenText( 20, 135,
			"When clicked, the politician starts spreading promises that roll down the hills\n"
			"and find the masses. If the dudes from the masses like the promise, they start\n"
			"seeking the politician that gave the promise. When they find it, they add a vote\n"
			"to his party and go to heaven.", 0xD0FFFFFF );
		getTextRenderer().renderScreenText( 20, 200,
			"You'll find that the masses like downhills, and the politicians like the high\n"
			"areas. Also at the very first move, the green party automatically launches some\n"
			"promises - that's to compensate for red's first move.", 0xD0FFFFFF );
		getTextRenderer().renderScreenText( 20, 250,
			"The controls are: 1/2/3/4 for switching the promises. S/X and A/D for camera\n"
			"movement, Z/C for camera strafe. Space is needed between turns.", 0xD0FFFFFF );
			*/
	}
}

