/**
 *  @file game/MyGame.h
 *  Your game application code.
 */

#ifndef __MY_GAME_H
#define __MY_GAME_H

#include "Lumberjack.h"
#include "../engine/BaseGame.h"
#include "../utils/FixedPool.h"
#include "../utils/Singleton.h"

#include "Sectors.h"
#include "Places.h"

#include "TreeEntity.h"
#include "Missile.h"
#include "Villager.h"


class CMesh;
class CBasicCamera;

/**
 *  Your game application class.
 */
class CMyGame : public CBaseGame, public CSingleton<CMyGame>
{
public:
	enum { NUM_TOWERS = 2 };
	enum eControlMode { TOWER = 0, FLY = 1, WALK = 2, DIALOG = 3 };
public:
	typedef CFixedPool<CLumberjack>	TLumberjackPool;
	typedef CFixedPool<CTreeEntity>	TTreePool;
	typedef CFixedPool<CMissile>	TMissilePool;
	
public:
	static void init( CConfig& config ) {
		CMyGame* game = new CMyGame( config ); assert( game );
		assignInstance( *game );
	}
	virtual ~CMyGame();

	bool hasSpace() const;
	
protected:
	/// Receive left mouse button change.
	virtual void	onMouseLChange( bool pressed );
	/// Receive right mouse button change.
	virtual void	onMouseRChange( bool pressed );
	/// Receive key state change.
	virtual void	onKeyChange( int key, bool pressed );
	
	/**
	 *  Initialize the game.
	 */
	virtual	void onInitialize();
	
	/**
	 *  Process input.
	 *  The engine calls this method for processing input.
	 */
	virtual void onProcessInput( const CFrameTime& frameTime );

	/**
	 *  Execute game logic.
	 *  The engine calls this method when game update time comes.
	 */
	virtual void onUpdate();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method before rendering anything.
	 */
	virtual void onRenderBeforeAll();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method after rendering all world
	 *  objects.
	 */
	virtual void onRenderAfterWorld();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method after rendering everything.
	 */
	virtual void onRenderAfterAll();

private:
	void	manageCameraUpdate();
	

protected:
	virtual CCamera* createCamera();

private:
	CMyGame( CConfig& config );

	static CMyGame* createInstance() {
		assert( !"Must be initialized first" );
		return 0;
	}

	static void deleteInstance( CMyGame& instance ) {
		delete &instance;
	}

	void restartGame();

	friend CSingleton<CMyGame>;	

private:
	CBasicCamera*	mTerrainCamera;

public:
	TLumberjackPool*	mLumberjacks;
	TTreePool*			mTrees;
	//TCargoPool*			mCargo;
	
	TMissileGrid		mMissileGrid;
	TForestGrid			mForestGrid;

	CTower				mTowers[NUM_TOWERS];
	CMesh*				mTowerMeshes[NUM_TOWERS];
	int					mMyTower;
	eControlMode		mControlMode;

	TVillagePool*		mVillages;

	/*
	bool			mJustChangedPolitician;

	SSectorWithRay	mRay;
	TPoliticalGrid	mPoliticalGrid;

	CGoods::eGoods	mActiveGoods;

	int				mTotalTurns;
	int				mTurnNumber;
	bool			mEvilTurn;
	int				mTurnCounter;
	bool			mTurnPause;

	int				mScoreEvil;
	int				mScoreGood;

	int		mLeft[CGoods::MAX_GOODS];
	*/

	bool	mIntro;
};

#endif
