
#ifndef __TOWN_H
#define __TOWN_H

#include "../utils/FixedPool.h"

// ------------------------------------------------------------------

class CPlace {
public:
	void	init( float x, float y, float size ) {
		mX = x;
		mY = y;
		setSize( size );
	}

	float	getX() const { return mX; }
	float	getY() const { return mY; }
	float	getSize() const { return mSize; }
	float	getSizeSq() const { return mSizeSq; }

	void	setSize( float s ) { mSize = s; mSizeSq = s*s; }

private:
	float	mX;
	float	mY;
	float	mSize;
	float	mSizeSq;
};


// ------------------------------------------------------------------

class CVillage : public CPlace {
public:
	void init( float x, float y, float size, int population, int price ) {
		CPlace::init( x, y, size );
		mPopulation = population;
		mPrice = price;
		mParty = -1;
	}
public:
	int		mPopulation;
	int		mPrice;
	int		mParty;
};
typedef CFixedPool<CVillage>	TVillagePool;


// ------------------------------------------------------------------

class CTower : public CPlace {
public:
public:
	int		mHeight;
};


#endif
