#include "TreeEntity.h"

#include "MyGame.h"
#include "../engine/Terrain.h"
#include "../engine/resource/PictureBundle.h"
#include "../utils/Random.h"
#include "Sectors.h"


// ENGINE CONSTANTS
#include "EngineConstants.h"


bool CTreeEntity::mInitedPictures = false;

struct STreePictures {
	const CPicture*	mNormal;
	const CPicture*	mBurn1[2];
	const CPicture*	mBurn2[2];
	const CPicture*	mBurn3[2];
	const CPicture*	mBurned;
};

static STreePictures gTreePictures[ 4 ];


void CTreeEntity::initPictures()
{
	mInitedPictures = true;
	CPictureBundle& pb = CPictureBundle::getInstance();
	std::string tree = "Tree";

	for( int i = 0; i < 4; ++i ) {
		STreePictures& tp = gTreePictures[i];
		//char ii = '1' + i;
		char ii = '1' + 0;
		tp.mNormal = pb.getResourceById( CResourceId( tree+ii+".png" ) );
		tp.mBurn1[0] = pb.getResourceById( CResourceId( tree+ii+"burn1a.png" ) );
		tp.mBurn1[1] = pb.getResourceById( CResourceId( tree+ii+"burn1b.png" ) );
		tp.mBurn2[0] = pb.getResourceById( CResourceId( tree+ii+"burn2a.png" ) );
		tp.mBurn2[1] = pb.getResourceById( CResourceId( tree+ii+"burn2b.png" ) );
		tp.mBurn3[0] = pb.getResourceById( CResourceId( tree+ii+"burn3a.png" ) );
		tp.mBurn3[1] = pb.getResourceById( CResourceId( tree+ii+"burn3b.png" ) );
		tp.mBurn1[0] = pb.getResourceById( CResourceId( tree+ii+"burn1a.png" ) );
		tp.mBurned = pb.getResourceById( CResourceId( tree+ii+"burned.png" ) );
	}
}


void CTreeEntity::updatedAge()
{
	setSize( 1.0f + (float)mAge * 5.0f / GROW_TIME );
	getPosition().z = CMyGame::getInstance().getTerrain().getAltitude( getPosition().x, getPosition().y ) + getSize()*0.9f;
	getOldPosition() = getPosition();
}

void CTreeEntity::updatedPicture()
{
	const CPicture* pic = NULL;

	STreePictures& tp = gTreePictures[ mFlags & F_TYPEMASK ];

	if( mBurnCounter > 0 ) {
		// burning
		int frame = (mBurnCounter&2)>>1;
		if( mBurnCounter < BURN_TIME/3 )
			pic = tp.mBurn1[ frame ];
		else if( mBurnCounter < BURN_TIME*2/3 )
			pic = tp.mBurn2[ frame ];
		else if( mBurnCounter < BURN_TIME )
			pic = tp.mBurn3[ frame ];
		else
			pic = tp.mBurned;
	} else {
		// normal
		pic = tp.mNormal;
	}

	setPicture( *pic );
}


void CTreeEntity::init()
{
	// once
	if( !mInitedPictures )
		initPictures();

	mFlags = 0;
	mBurnCounter = mDryCounter = mDiseaseCounter = 0;

	// set position
	CTerrain& terr = CMyGame::getInstance().getTerrain();
	float posx = getPosition().x;
	float posy = getPosition().y;
	float posz;
	while( (posz = terr.getAltitude(posx,posy)) <= 0.0f ) {
		posx = random::randf( gcon::WORLD_X );
		posy = random::randf( gcon::WORLD_Y );
	}

	// set type based on altitude
	float maxAlt = terr.getMaxAltitude();
	posz += random::randfs( maxAlt * 0.18f );
	if( posz < maxAlt * 0.15f )
		mFlags = 0;
	else if( posz < maxAlt * 0.4f )
		mFlags = 3;
	else if( posz < maxAlt * 0.65f )
		mFlags = 2;
	else
		mFlags = 1;
	getPosition().x = posx;
	getPosition().y = posy;

	updatedPicture();
	
	// age
	mAge = GROW_TIME/4 + rand()%(GROW_TIME*3/4);
	updatedAge();

	
	SForestSector& s = CMyGame::getInstance().mForestGrid.getSectorByPosition( posx, posy );
	++s.mTotalTrees;

	int cc = 255 - (rand()&63);
	setColor( D3DCOLOR_XRGB(cc,cc,cc) );

	if( !(rand()&63) && !(mFlags & F_TYPEMASK) ) {
		mBurnCounter = 1 + (rand()&15);
		mFlags |= F_BURNING;
	}
}


void CTreeEntity::update()
{
	CMyGame& game = CMyGame::getInstance();

	updatedPicture();
	
	//
	// am i chopped?

	SForestSector& s = game.mForestGrid.getSectorByPosition( getPosition().x, getPosition().y );
	if( s.mLumberjack ) {
		/*
		float dx = getPosition().x - s.mLumberjack->getPosition().x;
		float dy = getPosition().y - s.mLumberjack->getPosition().y;
		float r = (getSize() + s.mLumberjack->getSize()) * 0.6f;
		if( dx*dx + dy*dy <= r*r ) {
			mFlags |= F_KILLED;
			--s.mTotalTrees;
		}
		*/
		if( mFlags & F_BURNING ) {
			mBurnCounter -= 60;
			if( mBurnCounter < 1 ) {
				mFlags &= ~F_BURNING;
				mBurnCounter = 0;
			}
		}
	}

	//
	// age

	if( mAge < GROW_TIME && !(mFlags&F_BURNING) )
		++mAge;
	updatedAge();

	//
	// burn
	
	if( mFlags & F_BURNING ) {
		// burn
		++mBurnCounter;
		if( mBurnCounter > BURN_TIME ) {
			mFlags &= ~F_BURNING;
		} else if( (mBurnCounter > BURN_TIME*3/4) && ~(mBurnCounter&31) ) {
			// spread burn
			float xx = getPosition().x + random::randfs( getSize() );
			float yy = getPosition().y + random::randfs( getSize() );
			if( xx >= 0.0f && xx < gcon::WORLD_X && yy >= 0.0f && yy < gcon::WORLD_Y ) {
				SForestSector& ss = game.mForestGrid.getSectorByPosition( xx, yy );
				++ss.mBurningAmount;
			}
		}
	} else if( !mBurnCounter && s.mBurningAmount ) {
		mBurnCounter = 1;
		mFlags |= F_BURNING;
		--s.mBurningAmount;
	}

	if( mDryCounter > 0 ) {
		++mDryCounter;
		++s.mDryAmount;
	}
	if( mDiseaseCounter > 0 ) {
		++mDiseaseCounter;
		++s.mDiseaseAmount;
	}
	
	/*
	//
	// set old position

	getOldPosition() = getPosition();


	if( mFlags & F_READY_TO_DIE ) {
		++mCounter;
		if( mCounter > DIE_TIME )
			mFlags |= F_KILLED;
		mVelocity.x *= 0.95f;
		mVelocity.y *= 0.95f;
		mVelocity.z += gcon::GRAVITY * 2.0f;
		getPosition() += mVelocity;
		return;
	}

	/*
	if( mLeader ) {
		// follow leader
		float dx = getPosition().x - mLeader->getPosition().x;
		float dy = getPosition().y - mLeader->getPosition().y;
		if( dx*dx + dy*dy < 400.0f ) {
			mFlags |= F_READY_TO_DIE;
			mCounter = 0;
			setColor( 0xFF8080FF );
			if( mLeader->isEvil() )
				++CMyGame::getInstance().mScoreEvil;
			else
				++CMyGame::getInstance().mScoreGood;
			--CMyGame::getInstance().mLeft[ mPreference ];
		} else {
			static int fakeCounter = 0;
			++fakeCounter;
			if( fakeCounter > 11 ) {
				D3DXVECTOR2 vec( dx, dy );
				D3DXVec2Normalize( &vec, &vec );
				mVelocity.x = mVelocity.x * 0.75f - vec.x * 0.3f;
				mVelocity.y = mVelocity.y * 0.75f - vec.y * 0.3f;
			}
		}
		++mCounter;
		if( mCounter > READY_TIME ) {
			mCounter = 0;
			mLeader = NULL;
			setColor( 0xFFFFFFFF );
		}
	} else*/ /*{
		// get additional velocity from slope
		D3DXVECTOR3 vel = mVelocity;
		float dx, dy;
		CMyGame::getInstance().getTerrain().getSlope( getPosition().x, getPosition().y, dx, dy );

		mVelocity.x -= dx;
		mVelocity.y -= dy;

		mVelocity *= 0.99f;
	}
	*/

	// check leader
	/*
	SPoliticalSector& s = CMyGame::getInstance().mPoliticalGrid.getSectorByPosition( getPosition().x, getPosition().y );
	if( s.mPromise && s.mPromise->getGoods() == mPreference ) {
		if( mLeader != &s.mPromise->getPolitician() )
			mVelocity.z += gcon::GRAVITY * 20.0f;
		mLeader = &s.mPromise->getPolitician();
		setColor( mLeader->isEvil() ? 0xFFFF9090 : 0xFF90FF90 );
	}
	*/
	/*
	D3DXVECTOR3 pos = getPosition() + mVelocity;


	//
	// bound to world

	if( pos.x >= gcon::WORLD_X || pos.x < 0.0f ) {
		mVelocity.x = -mVelocity.x;
		pos.x = getOldPosition().x;
	}
	if( pos.y >= gcon::WORLD_Y || pos.y < 0.0f ) {
		mVelocity.y = -mVelocity.y;
		pos.y = getOldPosition().y;
	}


	//
	// terrain height

	float h = CMyGame::getInstance().getTerrain().getAltitude( pos.x, pos.y ) + getSize();

	mVelocity.z -= gcon::GRAVITY*2.0f;
	if( pos.z < h ) {
		pos.z = h;
		getOldPosition().z = h;
		mVelocity.z = 0.0f; // TODO: bounce off?
	}

	getPosition() = pos;
	*/
}
