
#ifndef __TREE_ENTITY_H
#define __TREE_ENTITY_H

#include <d3dx8math.h>

#include "../engine/Entity.h"


#pragma pack(1)


class CTreeEntity : public CEntity {
public:
	enum {
		F_TYPEMASK = 3,
		F_KILLED = 4,
		F_BURNING = 8,
		F_DRYING = 16,
		F_DISEASE = 32
	};
	enum { GROW_TIME = 2000 };
	enum { BURN_TIME = 400 };
	enum { DRY_TIME = 1500 };
	enum { DISEASE_TIME = 1000 };
	
public:
	void	init();

	void	update();

private:
	void	updatedAge();
	void	updatedPicture();

	static void initPictures();
	
public:
	short	mFlags;
	short	mAge;
	short	mBurnCounter;
	short	mDryCounter;
	short	mDiseaseCounter;

	static bool mInitedPictures;
};

#pragma pack()

#endif
