#pragma warning( disable:4786 )
#include "Villager.h"

#include "MyGame.h"
#include "../engine/Terrain.h"
#include "../engine/resource/PictureBundle.h"
#include "../utils/Random.h"


// ENGINE CONSTANTS
#include "EngineConstants.h"



void CVillager::init( const CVillage* village, int health )
{
	mCounter = rand() & 63;

	mVillage = village;
	mHealth = health;
	mFlags = village ? F_INSIDE : 0;
	setSize( 5.5f );
	
	mVelocity.x = mVelocity.y = mVelocity.z = 0;
	mDeltaX = random::randfs( 20.0f );
	mDeltaY = random::randfs( 20.0f );
	if( village ) {
		float x = village.getX() + mDeltaX;
		float y = village.getY() + mDeltaY;
		if( x < 0.0f ) x = 0.0f;
		else if( x >= gcon::WORLD_X ) x = gcon::WORLD_X-gcon::EPSILON;
		if( y < 0.0f ) y = 0.0f;
		else if( y >= gcon::WORLD_Y ) y = gcon::WORLD_Y-gcon::EPSILON;

		getPosition().x = x;
		getPosition().y = y;
		getPosition().z = CMyGame::getInstance().getTerrain().getAltitude( x, y ) + getSize();
	}
	getOldPosition() = getPosition();
	
	int cc = 255 - (rand()&63);
	setColor( D3DCOLOR_XRGB(cc,cc,cc) );
	
	CResourceId rid = CResourceId( "Politician2.png" );
	setPicture( *CPictureBundle::getInstance().getResourceById( rid ) );
}

void CVillager::attract( float dx, float dy, float r2min, float r2max, float damp, float influence )
{
	float r2 = dx*dx + dy*dy;
	if( r2 > r2min && r2 < r2max ) {
		D3DXVECTOR2 vec( dx, dy );
		D3DXVec2Normalize( &vec, &vec );
		mVelocity.x = mVelocity.x * damp - vec.x * influence;
		mVelocity.y = mVelocity.y * damp - vec.y * influence;
	}
}


void CVillager::updateVillager()
{
	CMyGame& game = CMyGame::getInstance();

	D3DXVECTOR3 pos = getPosition();
	getOldPosition() = pos;
	
	//
	// i'm dead - no move

	if( mHealth <= 0 )
		return;

	//
	// walking logic

	
	++mCounter;
	if( !(mCounter&7) && mVillage ) {
		float posx = pos.x + mDeltaX;
		float posy = pos.y + mDeltaY;
		/*
			if( mVillage->mAttractor.mActive ) {
				// attract
				float dx = posx - mVillage->mAttractor.getX();
				float dy = posy - mVillage->mAttractor.getY();
				attract( dx, dy, 100, mVillage->mAttractor.getSizeSq(), 0.75f, 0.4f );
			}
			if( mVillage->mProtractor.mActive ) {
				// protract
				float dx = mVillage->mAttractor.getX() - posx;
				float dy = mVillage->mAttractor.getY() - posy;
				attract( dx, dy, 1, mVillage->mProtractor.getSizeSq(), 0.75f, 0.4f );
			}
		*/
		// check inside village
		float dx = pos.x - mVillage->getX();
		float dy = pos.y - mVillage->getY();
		if( dx*dx + dy*dy < mVillage->getSizeSq() ) {
			mFlags |= F_INSIDE;
		} else {
			mFlags &= ~F_INSIDE;
		}
	}

	if( (mCounter&31) == 3 ) {
		// random impulse
		mVelocity.x += random::randfs( 1.0f );
		mVelocity.y += random::randfs( 1.0f );
	}

	mVelocity *= 0.9f;

	
	pos += mVelocity;

	//
	// bound to world

	if( pos.x >= gcon::WORLD_X || pos.x < 0.0f ) {
		mVelocity.x = -mVelocity.x;
		pos.x = getOldPosition().x;
	}
	if( pos.y >= gcon::WORLD_Y || pos.y < 0.0f ) {
		mVelocity.y = -mVelocity.y;
		pos.y = getOldPosition().y;
	}

	//
	// terrain height

	float h = game.getTerrain().getAltitude( pos.x, pos.y ) + getSize();

	if( h <= 0.0f ) {
		// don't go to water
		float vx, vy;
		game.getTerrain().getSlope( pos.x, pos.y, vx, vy );
		mVelocity.x += vx;
		mVelocity.y += vy;
	}

	mVelocity.z -= gcon::GRAVITY*2.0f;
	if( pos.z < h ) {
		pos.z = h;
		getOldPosition().z = h;
		mVelocity.z = 0.0f;
	}

	getPosition() = pos;
}
