
#ifndef __VILLAGER_H
#define __VILLAGER_H

#include <d3dx8math.h>

#include "../engine/Entity.h"


#pragma pack(1)

class CVillage;


class CVillager : public CEntity {
public:
	enum {
		F_KILLED = 1,
		F_INSIDE = 2
	};
	
public:
	void	init( const CVillage* village, int health = 100 );

	void	update();

protected:
	void	updateVillager();
	void	attract( float dx, float dy, float r2min, float r2max, float damp, float influence );

public:
	D3DXVECTOR3	mVelocity;
	CVillage*	mVillage;
	short		mFlags;
	short		mHealth;
	short		mCounter;
	float		mDeltaX, mDeltaY;
};




#pragma pack()

#endif
