#include "NetClient.h"

//#include <iostream>
#include <cassert>
#include "netlib/Network.h"
#include "netlib/Commands.h"
#include "../../engine/console/Console.h"

static con::CChannel& CONSOLE = con::CConsole::getChannel( "net" );

CNetClient::CNetClient( const  std::string& server, int port )
:	mTick( 1 ), mGotLastTime( true )
{
	CONSOLE << "initializing" << con::endl;

	srand( timeGetTime() );
	Network::init();
	
	if( !mNetwork.connect( server, port ) ) {
		CONSOLE << "error: cannot connect to server" << con::endl;
		exit(1);
	}

	mNetwork.sendReady();

	unsigned long clientCount = 2;
	mID = 0;

	CONSOLE << "waiting for second client" << con::endl;
	
	while( !mNetwork.receiveReadyAll( mID, clientCount ) );

	assert( clientCount == 2 );

	CONSOLE << "all connected" << con::endl;
}

NetData* CNetClient::send( const D3DXVECTOR3& pos, const D3DXVECTOR3& velocity, int bombs, int owned )
{
	if( mGotLastTime ) {
		mData.mPosition = pos;
		mData.mVelocity = velocity;
		mData.mBombs = bombs;
		mData.mOwned = owned;
		mData.mID = mID;
		
		mNetwork.sendTick( mTick, &mData );

		mTick++;

		mHasSent = true;
	} else
		mHasSent = false;
		
	unsigned long newTick = mTick, clientCount = 2;
	//while( !mNetwork.receiveTick( newTick, mDataFromNet, clientCount ) );

	mGotLastTime = mNetwork.receiveTick( newTick, mDataFromNet, clientCount );

	if( mGotLastTime ) {
		if( mDataFromNet[0].mID != mID )
			return &mDataFromNet[0];
		else
			return &mDataFromNet[1];
	}

	return NULL;	
}

