#include "TerrainModifier.h"

#include "Terrain.h"
#include "../game/EngineConstants.h"


void CTerrainModifier::raise( CTerrain& terrain, float x, float y, float radius, float amount )
{
	int ix1, iy1;
	int ix2, iy2;
	terrain.getNearestCell( x-radius, y-radius, ix1, iy1 );
	terrain.getNearestCell( x+radius, y+radius, ix2, iy2 );

	if( ix1 < 0 ) ix1 = 0;
	else if( ix1 >= CTerrain::CELLS_X ) ix1 = CTerrain::CELLS_X-1;
	if( ix2 < 0 ) ix2 = 0;
	else if( ix2 >= CTerrain::CELLS_X ) ix2 = CTerrain::CELLS_X-1;

	if( iy1 < 0 ) iy1 = 0;
	else if( iy1 >= CTerrain::CELLS_Y ) iy1 = CTerrain::CELLS_Y-1;
	if( iy2 < 0 ) iy2 = 0;
	else if( iy2 >= CTerrain::CELLS_Y ) iy2 = CTerrain::CELLS_Y-1;

	float radius2 = radius*radius;
	
	terrain.beginUpdate();

	for( int iy = iy1; iy <= iy2; ++iy ) {
		float dy = ((float)iy / CTerrain::CELLS_Y) * gcon::WORLD_Y - y;
		for( int ix = ix1; ix <= ix2; ++ix ) {
			float dx = ((float)ix / CTerrain::CELLS_X) * gcon::WORLD_X - x;
			float r2 = dy*dy + dx*dx;
			if( r2 < radius2 ) {
				float a = cosf( r2 / radius2 * 3.14f * 0.5f );
				terrain.setAltitude( ix, iy, terrain.getAltitudeIdx(ix,iy) + amount * a );
			}
		}
	}

	terrain.endUpdate();
}


