
#include "TextRenderer.h"
#include "../dxutils/d3dfont.h"


CTextRenderer::CTextRenderer( const std::string& fontName, int fontSize, bool bold, bool italic )
{
	DWORD flags = 0;
	if( bold )
		flags |= D3DFONT_BOLD;
	if( italic )
		flags |= D3DFONT_ITALIC;
	mFont = new CD3DFont( fontName.c_str(), fontSize, flags );
}

CTextRenderer::~CTextRenderer()
{
	delete mFont;
}

HRESULT CTextRenderer::onCreateDevice( IDirect3DDevice8* device )
{
	CDXObject::onCreateDevice( device );
	return mFont->InitDeviceObjects( device );
}
HRESULT CTextRenderer::onLostDevice()
{
	CDXObject::onLostDevice();
	return mFont->InvalidateDeviceObjects();
}
HRESULT CTextRenderer::onResetDevice()
{
	CDXObject::onResetDevice();
	return mFont->RestoreDeviceObjects();
}
HRESULT CTextRenderer::onDestroyDevice()
{
	CDXObject::onDestroyDevice();
	return mFont->DeleteDeviceObjects();
}

void CTextRenderer::renderScreenText( int x, int y, const std::string& text, DWORD color )
{
	mFont->DrawText( x, y, color, text.c_str(), 0 );
}

