#include "Console.h"
#include <cassert>

using namespace con;


// --------------------------------------------------------------------------
// CConsole

CConsole* CConsole::mSingleInstance = 0;


CConsole* const CConsole::getConsole()
{
	if( !mSingleInstance )
		mSingleInstance = new CConsole();
	return mSingleInstance;
}

CChannel& CConsole::getChannel( const std::string& name )
{
	return getConsole()->openChannel( name );
}

CConsole::CConsole()
:	mDefaultRenderingCtx( NULL ),
	mDefaultFilter( NULL )
{
}

CConsole::CConsole( IConsoleRenderingContext& ctx )
:	mDefaultRenderingCtx( &ctx ),
	mDefaultFilter( NULL )
{
}

CConsole::~CConsole()
{
	for( TChannelList::iterator i = mChannels.begin(); i != mChannels.end(); ++i )
		delete *i;
}

CChannel& CConsole::openChannel( const std::string& name )
{
	CChannel* channel = NULL;
	for( TChannelList::iterator i = mChannels.begin(); i != mChannels.end(); ++i ) {
		if( (*i)->getName() == name )
			channel = *i;
	}
	if( !channel ) {
		channel = new CChannel( *this, name, mDefaultRenderingCtx, mDefaultFilter );
		mChannels.push_back( channel );
	}
	return *channel;
}

void CConsole::closeChannel( CChannel& channel )
{
	for( TChannelList::iterator i = mChannels.begin(); i != mChannels.end(); ++i ) {
		if( *i == &channel ) {
			delete *i;
			i = mChannels.erase( i );
		}
	}
}

void CConsole::setDefaultRenderingContext( IConsoleRenderingContext& ctx )
{ 
	mDefaultRenderingCtx = &ctx;

	for( TChannelList::iterator i = mChannels.begin(); i != mChannels.end(); ++i ) {
		if( !(*i)->getRenderingContext() )
			(*i)->setRenderingContext( ctx );
	}
}


//---------------------------------------------------------------------------
// CChannel


CChannel::CChannel( CConsole& console, const std::string& name, IConsoleRenderingContext* renderingCtx, IFilter* filter )
:	mParentConsole( console ),
	mName( name ),
	mRenderingCtx( renderingCtx ),
	mFilter( filter )
{
}

CChannel::~CChannel()
{
}

void CChannel::close()
{
	mParentConsole.closeChannel( *this );
}

void CChannel::write( const std::string& methodName, const std::string& message )
{
	write( message );
}

void CChannel::write( const std::string& message )
{
	if( mFilter )
		if( !mFilter->apply( *this, message ) )
			return;

	mRenderingCtx->write( mName );
	mRenderingCtx->write( "> " );
	mRenderingCtx->write( message );
	mRenderingCtx->write( "\n" );
}
