/**
 *  @file engine/resource/PictureBundle.h
 *  Picture bundle.
 */

#pragma warning( disable:4786 )
#ifndef __PICTURE_BUNDLE_H__
#define __PICTURE_BUNDLE_H__

#include "../Picture.h"
#include "BundleSingleton.h"
#include "StorageResourceBundle.h"


// ------------------------------------------------------------------

/**
 *  Sprite picture bundle.
 *  Use this to obtain entity pictures (CPicture). It's a singleton via
 *  static getInstance() method.
 *  @see CResourceId, IResourceBundle#getResourceById, IResourceBundle#rejectResource, IResourceBundle#clear.
 */
class CPictureBundle : public CStorageResourceBundle<CPicture>, public CBundleSingleton<CPictureBundle>
{
public:
	static void init( IDirect3DDevice8& device, std::string predir, int texSizeX, int texSizeY, int baseSize ) {
		CPictureBundle* bundle = new CPictureBundle( device, predir, texSizeX, texSizeY, baseSize );
		assert( bundle );
		assignInstance( *bundle );
	}

	const std::string& getPreDir() const { return mPreDir; }
	IDirect3DDevice8& getDevice() { return mDevice; }
	IDirect3DTexture8& getUnderlyingTexture() const { return *mTexture; }

	virtual void clear();
	
protected:
	virtual CPicture* loadResourceById( CResourceId const& id );
	virtual void touchResource( CPicture& resource );
	virtual void clearResource( CPicture& resource );

private:
	CPictureBundle( IDirect3DDevice8& device, std::string predir, int texSizeX, int texSizeY, int baseSize );
	virtual ~CPictureBundle();
	friend CBundleSingleton<CPictureBundle>;

	bool findSpace( int areasX, int areasY, int& ax, int& ay );
	
private:
	std::string const	mPreDir;
	IDirect3DDevice8&	mDevice;

	int					mTexSizeX;
	int					mTexSizeY;
	int					mBaseSize;
	IDirect3DTexture8*	mTexture;
	IDirect3DSurface8*	mSurface;
	
	int					mAreasX;
	int					mAreasY;
	
	bool*				mFreeAreas;
	int					mFreeAreasCount;
	
	CPicture			mDefaultPicture;
};


#endif
