#pragma warning(disable:4786)
#include "Home.h"

#include "MyGame.h"
#include "MyEntity.h"
#include "../engine/EntityRenderer.h"
#include "../engine/Terrain.h"
#include "../engine/TerrainModifier.h"
#include "../engine/resource/PictureBundle.h"
#include "../utils/Random.h"


void CHome::init()
{
//	mWarriorProducerPosition = mPosition + D3DXVECTOR3( 100 * mModifier, 70 * mModifier, 0 );
//	mHarversterProducerPosition = mPosition + D3DXVECTOR3( -150 * mModifier, 70 * mModifier, 0 );
//	mVultureProducerPosition = mPosition + D3DXVECTOR3( -100 * mModifier, 250 * mModifier, 0 );

	mWarriorProducerPosition = mPosition + D3DXVECTOR3( 70 * mModifier, -70 * mModifier, 0 );
	mHarversterProducerPosition = mPosition + D3DXVECTOR3( -100 * mModifier, 0 * mModifier, 0 );
	mVultureProducerPosition = mPosition + D3DXVECTOR3( -20 * mModifier, 80 * mModifier, 0 );
}

void CHome::produce()
{
	CPictureBundle& pb = CPictureBundle::getInstance();
	const CPicture& pic1 = *pb.getResourceById( CResourceId("Sprite.png") );

/*	mWarriorProducerPosition = mPosition + D3DXVECTOR3( 0, 300 * mModifier, 0 );
	mHarversterProducerPosition = mPosition + D3DXVECTOR3( -100 * mModifier, 0, 0 );
	mVultureProducerPosition = mPosition + D3DXVECTOR3( 100 * mModifier, 0, 0 );*/
	init();

	int count = 3; int i;

	CMyGame& myGame = CMyGame::getInstance();
	if( !myGame.hasSpace() || mSize <= mMinProductionSize )
		return;

	CTeam& team = myGame.getTeamByHome( *this );

	mVultureProduce += mVultureProduceFactor;
	mHarvesterProduce += mHarvesterProduceFactor;
	mWarriorProduce += mWarriorProduceFactor;

	//for( i = 0; i < mVultureProduce; ++i ) 
	while( mVultureProduce > 1.0f ) {
		CMyEntity& e = myGame.mPool->add();
		myGame.getEntities().add( e );
		e.getPosition() = mVultureProducerPosition;
		e.mVelocity = D3DXVECTOR3( random::randfs(3.0f), random::randf(3.0f), 0.0f );
		e.getOldPosition() = e.getPosition();
		e.mDeciderCounter = rand()&15;
		e.mDecider = &team.mFollowOverlordV;
		e.setPicture( pic1 );
		e.setSize( 1.0f );
		e.setColor( mVultureColor );
		e.mFlags = CMyEntity::F_GRAVITY | CMyEntity::F_VULTURE | mTeamFlag;

		e.mStrength = 1.0f;
		e.mEnergy = 3.0f;

		e.init();

		reduce( 1.0f );
		mVultureProduce--;
	}

//	for( i = 0; i < mHarvesterProduce; ++i ) {
	while( mHarvesterProduce > 1.0f ) {
		CMyEntity& e = myGame.mPool->add();
		myGame.getEntities().add( e );
		e.getPosition() = mHarversterProducerPosition;
		e.mVelocity = D3DXVECTOR3( random::randfs(3.0f), random::randf(3.0f), 0.0f );
		e.getOldPosition() = e.getPosition();
		e.mDeciderCounter = rand()&15;
		e.mDecider = &team.mFollowOverlordH;
		e.setPicture( pic1 );
		e.setSize( 1.5f );
		e.setColor( mHarvesterColor );
		e.mFlags = CMyEntity::F_GRAVITY | CMyEntity::F_HARVERSTER | mTeamFlag;

		e.mStrength = 5.0f;
		e.mEnergy = 1.0f;

		e.init();

		reduce( 1.0f );
		mHarvesterProduce--;
	}

//	for( i = 0; i < mWarriorProduce; ++i ) {
	while( mWarriorProduce > 1.0f ) {
		CMyEntity& e = myGame.mPool->add();
		myGame.getEntities().add( e );
		e.getPosition() = mWarriorProducerPosition;
		e.mVelocity = D3DXVECTOR3( random::randfs(3.0f), random::randf(3.0f), 0.0f );
		e.getOldPosition() = e.getPosition();
		e.mDeciderCounter = rand()&15;
		e.mDecider = &team.mFollowOverlordW;
		e.setPicture( pic1 );
		e.setSize( 1.5f );
		e.setColor( mWarriorColor );
		e.mFlags = CMyEntity::F_GRAVITY | CMyEntity::F_WARRIOR | mTeamFlag;

		e.mStrength = 1.0f;
		e.mEnergy = 2.0f;

		
		e.init();

		reduce( 3.0f );
		mWarriorProduce--;
	}

	CTerrainModifier::raise( CMyGame::getInstance().getTerrain(), mPosition.x, mPosition.y, 100.0f, -( mOldSize - mSize ) * 0.1f );
	mOldSize = mSize;
}