#include "MyEntity.h"

#include "Decider.h"
#include "MyGame.h"
#include "../engine/Terrain.h"


// ENGINE CONSTANTS
#include "EngineConstants.h"

void CUfoEntity::init()
{
	mAnimator.init( 
		CMyGame::getInstance().mUfoAnimationSet,
		CMyGame::getInstance().getHackFrameTimeForAnimation() );
}

void CUfoEntity::update()
{
	//
	// set old position

	getOldPosition() = getPosition();

	D3DXVECTOR3 velocity = getPosition() - mCenter;
	float d = 30000 / -D3DXVec3LengthSq( &velocity ) ;

	D3DXVec3Normalize( &velocity, &velocity );
	velocity *= d;

	SMySector& sector = CMyGame::getInstance().mGrid.getSectorByPosition( 
		getPosition().x,
		getPosition().y );

	velocity += sector.gravity * mMind;

	D3DXVECTOR3 pos = getPosition() + velocity;

	//
	// bound to world

	if( pos.x >= gcon::WORLD_X || pos.x < 0.0f ) {
		pos.x = getOldPosition().x;
	}
	if( pos.y >= gcon::WORLD_Y || pos.y < 0.0f ) {
		pos.y = getOldPosition().y;
	}

	//
	// TODO: buildings


	if( sector.rocket > 0 )
	{
		mFlags |= F_KILLED;
	}

	if( sector.planet )
	{
		mFlags |= F_KILLED;
		sector.planet->damage( mStrength );
	}

	//
	pos.z = 70.0f;

	setPicture( mAnimator.getPicture() );

	getPosition() = pos;
}


void CRocketEntity::init()
{
	mAnimator.init(
		CMyGame::getInstance().mRocketAnimationSet,
		CMyGame::getInstance().getHackFrameTimeForAnimation() );
}

void CRocketEntity::update()
{
	//
	// set old position

	getOldPosition() = getPosition();

	D3DXVECTOR3 pos = getPosition() + mVelocity;

	//
	// bound to world

	if( pos.x >= gcon::WORLD_X || pos.x < 0.0f ) {
		pos.x = getOldPosition().x;
		mFlags |= F_KILLED;
	}
	if( pos.y >= gcon::WORLD_Y || pos.y < 0.0f ) {
		pos.y = getOldPosition().y;
		mFlags |= F_KILLED;
	}

	SMySector& sector = CMyGame::getInstance().mGrid.getSectorByPosition( 
		pos.x,
		pos.y );

	sector.rocket += mStrength;

	if( mFlags & F_ROCKET ) {
		mVelocity += sector.gravity;

		if( sector.planet )
		{
			mFlags |= F_KILLED;
			sector.planet->damage( 0.05f );
		}
	}
	
	mLifeTime--;
	if( mLifeTime <= 0.0f )
	{
		if( mFlags & F_ROCKET )
			CMyGame::getInstance().explode( getOldPosition() );

		mFlags |= F_KILLED;
	}

	//
	pos.z = 70.0f;

	setPicture( mAnimator.getPicture() );

	getPosition() = pos;
}