/**
 *  @file game/MyEntity.h
 *  Your game entity.
 */

#ifndef __GAME_ENTITY_H
#define __GAME_ENTITY_H

#include <d3dx8math.h>

#include "../engine/Entity.h"
#include "../engine/animator/Animator.h"

class IDecider;

#pragma pack(1)


/**
 *  Your game entity.
 */
class CUfoEntity : public CEntity {
public:
	enum {
		F_KILLED = 1
	};

public:
	void	init();
	void	update();
	
public:
	D3DXVECTOR3	mCenter;
	short		mFlags;

	float		mStrength;
	float		mMind;

	CAnimator<2.0f>	mAnimator;
};


class CRocketEntity : public CEntity
{
public:
	enum {
		F_ROCKET = 1,
		F_PROJECTILE = 2,
		F_KILLED = 4
	};

public:
	void	init();
	void	update();

public:
	D3DXVECTOR3	mVelocity;
	short		mFlags;

	float		mStrength;
	float		mLifeTime;

	CAnimator<2.0f>	mAnimator;
};

#pragma pack()

#endif
