#pragma warning(disable:4786)

#include "MyGame.h"
#include "../engine/EntityRenderer.h"
#include "../engine/Mesh.h"
#include "../engine/Terrain.h"
#include "../engine/Billboarder.h"
#include "../engine/TextRenderer.h"
#include "../engine/TerrainGen.h"
#include "../engine/camera/BasicCamera.h"
#include "../engine/resource/PictureBundle.h"
#include "../engine/resource/TextureBundle.h"

// ENGINE CONSTANTS
#include "EngineConstants.h"
#include "../utils/Random.h"

#include <cassert>


// ------------------------------------------------------------------
//  basic stuff


CMyGame::CMyGame( CConfig& config )
:	CBaseGame( config ),
	mTerrainCamera( NULL ),
	mUfoPool( NULL ),
	mRocketPool( NULL ),
	mCenter( 512, 512, 0 ),
	mBoomDistance( 30.0f ),
	mLaunchDirection( 3.14f/ 2.0f ),
	mCounter( 3 ),
	mMind( 0.0f ),
	mGameOver( false )
{
/*	mPlanet.getWorldMatrix()._41 = 700.0f;
	mPlanet.getWorldMatrix()._42 = 512.0f;
	mPlanet.getWorldMatrix()._43 = 70.0f;

	mPlanet.mMass = 10.0f;*/
}

CMyGame::~CMyGame()
{
	delete mUfoPool;
	delete mRocketPool;
}

CCamera* CMyGame::createCamera()
{
	mTerrainCamera = new CBasicCamera();
	mTerrainCamera->getPosition() = D3DXVECTOR3( gcon::WORLD_X * 0.5f, gcon::WORLD_Y * 0.5f, 100.0f );

	return mTerrainCamera;
}

// ------------------------------------------------------------------
//  input


void CMyGame::onMouseLChange( bool pressed )
{
}

void CMyGame::onMouseRChange( bool pressed )
{
}

void CMyGame::onKeyChange( int key, bool pressed )
{
}

void CMyGame::onProcessInput()
{
	assert( mTerrainCamera );

	// update rotation from keys
	if( getKeyboard().isKeyPressed(VK_UP) )		mTerrainCamera->doPitch( 0.05f );
	if( getKeyboard().isKeyPressed(VK_DOWN) )	mTerrainCamera->doPitch( -0.05f );
	if( getKeyboard().isKeyPressed(VK_LEFT) )	{ mTerrainCamera->doYaw( 0.05f ); mLaunchDirection += 0.025f; }
	if( getKeyboard().isKeyPressed(VK_RIGHT) )	{ mTerrainCamera->doYaw( -0.05f ); mLaunchDirection -= 0.025f; }
//	if( getKeyboard().isKeyPressed('S') )		mTerrainCamera->doMove( 70.0f );
//	if( getKeyboard().isKeyPressed('X') )		mTerrainCamera->doMove( -70.0f );
//	if( getKeyboard().isKeyPressed('Z') )		mTerrainCamera->doStrafe( -40.0f );
//	if( getKeyboard().isKeyPressed('C') )		mTerrainCamera->doStrafe( 40.0f );
	if( getKeyboard().isKeyPressed('Q') )		mTerrainCamera->doRise( 40.0f );
	if( getKeyboard().isKeyPressed('A') )		mTerrainCamera->doRise( -40.0f );

	if( getKeyboard().isKeyPressed('X') )		mBoomDistance += 0.1f;
	if( getKeyboard().isKeyPressed('Z') )		mBoomDistance -= 0.1f;

	if( getKeyboard().isKeyPressed(' ') )		launchRocket();

	mBoomDistance = min( mBoomDistance, 100 );
	mBoomDistance = max( mBoomDistance, 7 );
}


// ------------------------------------------------------------------
//  initialization


void CMyGame::onInitialize()
{
	mTerrainCamera->setTerrain( getTerrain() );

	int maxEntities = getEntities().getMaxEntities();
	mUfoPool = new TUfoPool( maxEntities );
	mRocketPool = new TRocketPool( maxEntities );

	CPictureBundle& pb = CPictureBundle::getInstance();
	const CPicture& pic1 = *pb.getResourceById( CResourceId("Sprite.png") );
	
	CTerrainGen::fillTexture( getTerrain(), CResourceId("TerrainGray.png"), -50.0f, 100.0f );

	int count = maxEntities/2;



/*	int i;

	for( i = 0; i < count; ++i ) {
		CUfoEntity& e = mUfoPool->add();
		getEntities().add( e );
	
		float r = random::randf( 70.0f );
		float o = random::randf( 2*3.14f );

		D3DXVECTOR3 p;
		p.x = cos( o ) * ( r + 400 );
		p.y = sin( o ) * ( r + 400 );
		p.z = 0;

		D3DXVECTOR3 v;
		D3DXVec3Normalize( &v, &p );

		p += mCenter;
		
		e.getPosition() = p;
		e.mCenter = mCenter; //D3DXVECTOR3( -v.x, -v.y, 0.0f );
		e.getOldPosition() = e.getPosition();
		e.setPicture( pic1 );
		e.setSize( 2.0f );
		e.setColor( 0xFFFFFFFF );
		e.mStrength = 0.01f;
		e.mMind = 3.0f;
//		e.mFlags = CMyEntity::F_GRAVITY;

		e.init();
	}*/

	level();

	const CPicture& p1 = *pb.getResourceById( CResourceId("worker_over1.png") );
	const CPicture& p2 = *pb.getResourceById( CResourceId("worker_over2.png") );
	const CPicture& p3 = *pb.getResourceById( CResourceId("AngryGod.png") );

	mUfoAnimationSet.add( p1 );
	mUfoAnimationSet.add( p2 );

	mRocketAnimationSet.add( p3 );


	static CMesh* mesh = new CMesh( 
		CResourceId( "sphere10.x" ),
		CResourceId( "TexturedMesh.sha" ),
		CResourceId( "TerrainGray.png" ) );
	mesh->getWorldMatrix()._11 = 10;
	mesh->getWorldMatrix()._22 = 10;
	mesh->getWorldMatrix()._33 = 20;
	mesh->getWorldMatrix()._41 = 300;
	mesh->getWorldMatrix()._42 = 400;


//	getObjects().addObject( *mesh );

//	float speed;
//	float lastRotation = 0;
 
/*	mAllMass = 0;
	for( int q = 0; q < PLANETS_COUNT; ++q )
	{
//		if( ( q % 2 ) == 0 )
		float speed = random::randf( 3.14f / 7100.0f );

		float rotation = random::randf( 3.14f * 2.0f );
//		rotation = max( rotation - lastRotation, 0.4f );
//		lastRotation = rotation;

		mPlanet[q].mSpeed = speed;
		mPlanet[q].mRotation = rotation;
		mPlanet[q].mRadius = 50 + q * 40 + random::randf( 15.0f );
		mPlanet[q].mMass = 3.0f + random::randf( 3.0f );
 
		mAllMass += mPlanet[q].mMass;

		getObjects().addObject( mPlanet[q] );
	}*/
}


// ------------------------------------------------------------------
//  game logic


void CMyGame::onUpdate()
{
	if( mGameOver )
		return;

	if( mCounter > 0)
		mCounter--;

	if( mUfoPool->size() < 300 )
	{
		level();
	}
	
	mGrid.onUpdateBegin();

	for( int q = 0; q < PLANETS_COUNT; ++q )
	{
		mPlanet[q].update();
	}

	// update entities
	TRocketPool::iterator it;
	for( it = mRocketPool->begin(); it != mRocketPool->end();  ) {
		CRocketEntity& e = *it;
		e.update();
		if( e.mFlags & CRocketEntity::F_KILLED ) {
			it = mRocketPool->erase( it );
			getEntities().remove( e );
		} else {
			++it;
		}
	}

	TUfoPool::iterator it2;
	for( it2 = mUfoPool->begin(); it2 != mUfoPool->end();  ) {
		CUfoEntity& e = *it2;
		e.update();
		if( e.mFlags & CUfoEntity::F_KILLED ) {
			it2 = mUfoPool->erase( it2 );
			getEntities().remove( e );
		} else {
			++it2;
		}
	}

	mUfoAnimationSet.update( getHackFrameTimeForAnimation() );
	mRocketAnimationSet.update( getHackFrameTimeForAnimation() );
}


// ------------------------------------------------------------------
//  rendering

void CMyGame::onRenderBeforeAll()
{
	float mass = 0;
	for( int q = 0; q < PLANETS_COUNT; ++q )
	{
		mass += mPlanet[q].mMass;
	}

	if( mass / mAllMass < 0.3f )
		gameOver( false );

	getBillboarder().beginBillboards();

	getBillboarder().putScreenBill(
		CResourceId("Bar.png"), 0x8000ff00, -1.0f, 0.9f, mBoomDistance / 100 * 2.0f - 1.0f, 1.0f );

	getBillboarder().putScreenBill(
		CResourceId("Bar.png"), 0x80ff0000, -1.0f, 0.8f, mass / mAllMass * 2.0f - 1.0f, 0.89f );

	if( mGameOver )
	{
		if( mWin )
			getBillboarder().putScreenBill(
				CResourceId("YouWin.png"), 0xe0ffffff, -0.8f, -0.4f, 0.8f, 0.4f );
		else
			getBillboarder().putScreenBill(
				CResourceId("YouLose.png"), 0xe0ffffff, -0.8f, -0.4f, 0.8f, 0.4f );
	}

	getBillboarder().endBillboards();
}

void CMyGame::onRenderAfterWorld()
{
}

void CMyGame::onRenderAfterAll()
{
	char* str = new char[33];

	itoa( (int)getEntities().getEntityCount(), str, 10 );
	getTextRenderer().renderScreenText( 10, 90, str );
}

void CMyGame::launchRocket()
{
	if( mCounter > 0 )
		return;

	mCounter = 3;

	const CPicture& pic = *CPictureBundle::getInstance().getResourceById( CResourceId("AngryGod.png") );

	CRocketEntity& e = mRocketPool->add();
	getEntities().add( e );

	D3DXVECTOR3 p;
	p.x = cos( mLaunchDirection ) * ( 0 );
	p.y = sin( mLaunchDirection ) * ( 0 );
	p.z = 0;


	D3DXVECTOR3 v;
	v.x = cos( mLaunchDirection ) * ( 1.0f );
	v.y = sin( mLaunchDirection ) * ( 1.0f );
	v.z = 0;
	
	v *= 7.0f + mBoomDistance / 20.f;
	p += mCenter;

	e.getPosition() = p;
	e.mVelocity = v;
	e.getOldPosition() = e.getPosition();
	e.setPicture( pic );
	e.setSize( 3.0f );
	e.setColor( 0xFFFFFFFF );
	e.mStrength = 0.0f;
	e.mLifeTime = mBoomDistance;
	e.mFlags = CRocketEntity::F_ROCKET;

	e.init();
}

void CMyGame::explode( D3DXVECTOR3 const& origin )
{
	const CPicture& pic = *CPictureBundle::getInstance().getResourceById( CResourceId("God.png") );

	int count = 1000;
	for( int i = 0; i < count; ++i ) {
		CRocketEntity& e = mRocketPool->add();
		getEntities().add( e );
	
//		float r = random::randf( 1.0f );
		float o = random::randf( 2*3.14f );

/*		D3DXVECTOR3 p;
		p.x = cos( o ) * (  );
		p.y = sin( o ) * ( r + 300 );
		p.z = 0;*/

		D3DXVECTOR3 v;
		v.x = cos( o );
		v.y = sin( o );

		v *= 10.0f;

		e.getPosition() = origin;
		e.mVelocity = v;
		e.getOldPosition() = e.getPosition();
		e.setPicture( pic );
		e.setSize( 3.0f );
		e.setColor( 0xFFFFFFFF );
		e.mStrength = 1.0f;
		e.mLifeTime = 10.0f;
		e.mFlags = CRocketEntity::F_PROJECTILE;

		e.init();
	}
}

void CMyGame::level()
{
	mMind += 0.5f;

	const CPicture& pic1 = *CPictureBundle::getInstance().getResourceById( CResourceId("Sprite.png") );

	int maxEntities = getEntities().getMaxEntities();

	// remove entities
	TRocketPool::iterator it;
	for( it = mRocketPool->begin(); it != mRocketPool->end();  ) {
		CRocketEntity& e = *it;
		it = mRocketPool->erase( it );
		getEntities().remove( e );
	}

	TUfoPool::iterator it2;
	for( it2 = mUfoPool->begin(); it2 != mUfoPool->end();  ) {
		CUfoEntity& e = *it2;
		it2 = mUfoPool->erase( it2 );
		getEntities().remove( e );
	}
	
	mUfoPool->clear();
	mRocketPool->clear();


	static div = 10; div--;
	if( div == 1 )
		gameOver( true );

	int count = maxEntities/ div;

	int i;

	D3DXCOLOR c;
	c.r = 255;
	c.g = div *25;
	c.b = div *25;

	for( i = 0; i < count; ++i ) {
		CUfoEntity& e = mUfoPool->add();
		getEntities().add( e );
	
		float r = random::randf( 70.0f );
		float o = random::randf( 2*3.14f );

		D3DXVECTOR3 p;
		p.x = cos( o ) * ( r + 400 );
		p.y = sin( o ) * ( r + 400 );
		p.z = 0;

		D3DXVECTOR3 v;
		D3DXVec3Normalize( &v, &p );

		p += mCenter;
		
		e.getPosition() = p;
		e.mCenter = mCenter; //D3DXVECTOR3( -v.x, -v.y, 0.0f );
		e.getOldPosition() = e.getPosition();
		e.setPicture( pic1 );
		e.setSize( 2.0f );
		e.setColor( 0xFFFFFFFF );
		e.mStrength = 0.01f;
		e.mMind = mMind;
//		e.mFlags = CMyEntity::F_GRAVITY;

		e.init();
	}

 
	mAllMass = 0;
	for( int q = 0; q < PLANETS_COUNT; ++q )
	{
		float speed = random::randf( 3.14f / 7100.0f );

		float rotation = random::randf( 3.14f * 2.0f );

		mPlanet[q].mSpeed = speed;
		mPlanet[q].mRotation = rotation;
		mPlanet[q].mRadius = 50 + q * 40 + random::randf( 15.0f );
		mPlanet[q].mMass = 3.0f + random::randf( 3.0f );
 
		mAllMass += mPlanet[q].mMass;

		getObjects().addObject( mPlanet[q] );
	}
}

void CMyGame::gameOver( bool win )
{
	mGameOver = true;
	mWin = win;

/*	TRocketPool::iterator it;
	for( it = mRocketPool->begin(); it != mRocketPool->end();  ) {
		CRocketEntity& e = *it;
		e.getOldPosition() = e.getPosition();
	}

	TUfoPool::iterator it2;
	for( it2 = mUfoPool->begin(); it2 != mUfoPool->end();  ) {
		CUfoEntity& e = *it2;
		e.getOldPosition() = e.getPosition();
	}*/
}