/**
 *  @file game/MyGame.h
 *  Your game application code.
 */

#ifndef __MY_GAME_H
#define __MY_GAME_H

#include "MyEntity.h"
#include "MySector.h"
#include "MyPlanet.h"
#include "../engine/BaseGame.h"
#include "../utils/FixedPool.h"
#include "../utils/Singleton.h"

#include "../engine/animator/AnimationSet.h"
#include "../engine/Grid.h"



class CBasicCamera;
/**
 *  Your game application class.
 */
class CMyGame : public CBaseGame, public CSingleton<CMyGame>
{
public:
	enum { PLANETS_COUNT = 7 };

public:
	typedef CFixedPool<CUfoEntity>		TUfoPool;
	typedef CFixedPool<CRocketEntity>	TRocketPool;

public:
	static void init( CConfig& config ) {
		CMyGame* game = new CMyGame( config ); assert( game );
		assignInstance( *game );
	}
	virtual ~CMyGame();


	void launchRocket();
	void explode( D3DXVECTOR3 const& origin );

	void level();
	void gameOver( bool win );

protected:
	/// Receive left mouse button change.
	virtual void	onMouseLChange( bool pressed );
	/// Receive right mouse button change.
	virtual void	onMouseRChange( bool pressed );
	/// Receive key state change.
	virtual void	onKeyChange( int key, bool pressed );
	
	/**
	 *  Initialize the game.
	 */
	virtual	void onInitialize();
	
	/**
	 *  Process input.
	 *  The engine calls this method for processing input.
	 */
	virtual void onProcessInput();

	/**
	 *  Execute game logic.
	 *  The engine calls this method when game update time comes.
	 */
	virtual void onUpdate();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method before rendering anything.
	 */
	virtual void onRenderBeforeAll();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method after rendering all world
	 *  objects.
	 */
	virtual void onRenderAfterWorld();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method after rendering everything.
	 */
	virtual void onRenderAfterAll();


protected:
	virtual CCamera* createCamera();

private:
	CMyGame( CConfig& config );

	static CMyGame* createInstance() {
		assert( !"Must be initialized first" );
		return 0;
	}

	static void deleteInstance( CMyGame& instance ) {
		delete &instance;
	}

	friend CSingleton<CMyGame>;	

private:
	CBasicCamera*	mTerrainCamera;


public:
	typedef CGrid<SMySector,64,64>   TMyGrid;

	TMyGrid			mGrid;
	
	TUfoPool*		mUfoPool;
	TRocketPool*	mRocketPool;

	CPlanet			mPlanet[PLANETS_COUNT];

	D3DXVECTOR3		mCenter;
	float			mBoomDistance;
	float			mLaunchDirection;

	int				mCounter;

	float			mAllMass;

	float			mMind;

	bool			mGameOver;
	bool			mWin;

	CAnimationSet	mUfoAnimationSet;
	CAnimationSet	mRocketAnimationSet;
};

#endif