#include "MyPlanet.h"

#include "MyGame.h"
#include "MySector.h"
#include "../engine/Grid.h"
#include "../engine/FrameTime.h"
#include "../engine/resource/ResourceId.h"

CPlanet::CPlanet()
:	CMesh( CResourceId( "sphere10.X" ),
		  CResourceId( "Planet.sha" ),
		  CResourceId( "Terrain.png" ) ),
	mColor( 0xffffffff )
{
}

void CPlanet::render( CFrameTime const& frameTime )
{
	if( mMass < 1.0f )
		return;

	D3DXVECTOR3 v;
	v.x = cos( mRotation ) * ( mRadius );
	v.y = sin( mRotation ) * ( mRadius );
	v.z = 70;

	v += CMyGame::getInstance().mCenter;

	getWorldMatrix()._41 = v.x;
	getWorldMatrix()._42 = v.y;
	getWorldMatrix()._43 = v.z;

	mRotation += mSpeed;

	CMesh::render( frameTime );
}

void CPlanet::update()
{
	if( mMass < 1.0f )
		return;

	CMyGame::TMyGrid& grid = CMyGame::getInstance().mGrid;

	float hx = grid.getStepX() / 2;
	float hy = grid.getStepY() / 2;

	float pr2 = mMass * mMass * 100.0f;

	float x = hx;
	float y = hy;
	for( int q = 0; q < grid.getSecsY() - 1; ++q )
	{ 
		x = hx;
		for( int w = 0; w < grid.getSecsX() - 1; ++w )
		{
			x += grid.getStepX();

			D3DXVECTOR3 d( getWorldMatrix()._41 - x, getWorldMatrix()._42 - y, 0 );
			float r2 = D3DXVec3LengthSq( &d );

			D3DXVec3Normalize( &d, &d );
			d *= pr2 / r2;

			SMySector& sector = grid.getSectorByPosition( x, y );
			sector.gravity += d;

			if( r2 <= pr2 / 2.0f ) {
				grid.getSectorByPosition( x, y ).planet = this;
			}
		}
		y += grid.getStepX();
	}

	getWorldMatrix()._11 = mMass - .5f;
	getWorldMatrix()._22 = mMass - .5f;
	getWorldMatrix()._33 = mMass - .6f;

	if( mColor.g < 0.95f )
		mColor.g += 0.05f;

	if( mColor.b < 0.95f )
		mColor.b += 0.05f;
}

void CPlanet::damage( float strength )
{
	if( mMass < 1.0f )
		CMyGame::getInstance().explode( D3DXVECTOR3( getWorldMatrix()._41, getWorldMatrix()._42, getWorldMatrix()._43 ) );

	if( mColor.g > 0 )
		mColor.g -= strength * 5;

	if( mColor.b > 0 )
		mColor.b -= strength * 5;

	mMass -= strength;
}

void CPlanet::applyEffectParameters( ID3DXEffect& effect )
{
	effect.SetDword( "dwColor", mColor );
	CMesh::applyEffectParameters( effect );
}
