/**
 *  @file utils/MathUtil.h
 *  Some math stuff.
 */
#ifndef __MATHUTIL_H__
#define __MATHUTIL_H__

#include <d3dx8math.h>

/// Some math stuff.
namespace math {

void buildMatrix( D3DXMATRIX& out, const D3DXVECTOR3& x, const D3DXVECTOR3& y, const D3DXVECTOR3& z, const D3DXVECTOR3& origin );

void buildObjectMatrixXZ( D3DXMATRIX& out, const D3DXVECTOR3& front, const D3DXVECTOR3& right, const D3DXVECTOR3& origin );

void buildObjectMatrixXY( D3DXMATRIX& out, const D3DXVECTOR3& front, const D3DXVECTOR3& up, const D3DXVECTOR3& origin );



// ------------------------------------------------------------------
//  FPU hackery

/**
 *  Quick rounding of float to integer.
 *  6 cycles or so. Can be used for quick float->int conversion (eg. for
 *  positive numbers: int i = round( f - 0.5f )).
 */
inline int round( float a )
{
	int retval;
	__asm fld a
	__asm fistp retval
	return retval;
}


}; // namespace math


#endif
