
#ifndef __DX_OBJECT_H
#define __DX_OBJECT_H

#include <d3d8.h>
#include <list>
#include <cassert>


class CFrameTime;
class CDXObject {
public:
	virtual ~CDXObject() { }

	virtual void render( CFrameTime const& frameTime ) {};

	virtual HRESULT onCreateDevice( IDirect3DDevice8* device );
	virtual HRESULT onLostDevice();
	virtual HRESULT onResetDevice();
	virtual HRESULT onDestroyDevice();

protected:
	const IDirect3DDevice8&	getDevice() const { assert( mDevice ); return *mDevice; }
	IDirect3DDevice8&	getDevice() { assert( mDevice ); return *mDevice; }
	
private:
	IDirect3DDevice8*	mDevice;
};


class CDXObjectContainer : public CDXObject {
public:
	void addObject( CDXObject& o ) { mObjects.push_back( &o ); }
	void removeObject( CDXObject& o ) { mObjects.remove( &o ); }

	virtual void render( CFrameTime const& frameTime );
	
	virtual HRESULT onCreateDevice( IDirect3DDevice8* device );
	virtual HRESULT onLostDevice();
	virtual HRESULT onResetDevice();
	virtual HRESULT onDestroyDevice();

private:
	typedef std::list<CDXObject*>	TDXObjectList;
private:
	TDXObjectList	mObjects;
};


#endif

