
#include "Camera.h"


CCamera::CCamera()
{
	setProjectionParams( 3.1415927f * 0.5f, 1.3f, 10.0f, 1000.0f );
	D3DXMatrixIdentity( &mCameraMatrix );
	updateMatrices();
}

CCamera::~CCamera()
{
}


void CCamera::updateMatrices()
{
	D3DXMatrixInverse( &mViewMatrix, NULL, &mCameraMatrix );
}


void CCamera::setProjectionParams( float fov, float aspect, float znear, float zfar )
{
	D3DXMatrixPerspectiveFovLH( &mProjectionMatrix, fov, aspect, znear, zfar );
	mFOV = fov;
	mZNear = znear;
	mZFar = zfar;
	mViewHalfWidth = 1.0f / mProjectionMatrix._11;
	mViewHalfHeight = 1.0f / mProjectionMatrix._22;
}

void CCamera::setDeviceTransforms( IDirect3DDevice8& device, bool view, bool proj )
{
	if( view )
		device.SetTransform( D3DTS_VIEW, &mViewMatrix );
	if( proj )
		device.SetTransform( D3DTS_PROJECTION, &mProjectionMatrix );
}

D3DXVECTOR3 CCamera::getWorldRay( float x, float y ) const
{
	D3DXMATRIX m = mCameraMatrix;
	m._41 = m._42 = m._43 = 0.0f;
	D3DXVECTOR3 r = getCameraRay( x, y );
	D3DXVec3TransformCoord( &r, &r, &m );
	return r;
}

D3DXVECTOR3 CCamera::getCameraRay( float x, float y ) const
{
	return D3DXVECTOR3( x*mViewHalfWidth, -y*mViewHalfHeight, 1.0f );
}
