#pragma warning(disable:4786)
#ifndef __STORAGE_RESOURCE_BUNDLE_H
#define __STORAGE_RESOURCE_BUNDLE_H

#include <map>
#include <cassert>

#include "ResourceBundle.h"
#include "ResourceId.h"

/**
 *  Storage resource bundle.
 */
template<class T>
class CStorageResourceBundle : public IResourceBundle<T> {
private:
	typedef std::map<CResourceId, T*>	TResourceMap;
	
public:
	CStorageResourceBundle() {}
	virtual ~CStorageResourceBundle() = 0 {}
	
	T* getResourceById( CResourceId const& id )	{
		T* resource = findResource( id );
		if( !resource ) {
			resource = loadResourceById( id );
			assert( resource );
			mResourceMap.insert( std::make_pair( id, resource ) );
		}
		touchResource( *resource );
		return resource;
	}
	
	void rejectResource( CResourceId const& id ) {
		T* resource = findResource( id );
		if( !resource )
			return;
		clearResource( *resource );
		mResourceMap.erase( id );
	}
	
	void clear() {
		for( TResourceMap::iterator it = mResourceMap.begin(); it != mResourceMap.end(); ) {
			assert( (*it).second );
			clearResource( *(*it).second );
			it = mResourceMap.erase( it );
		}
	}
	
protected:
	T* findResource( CResourceId const& id ) {
		TResourceMap::const_iterator it = mResourceMap.find( id );
		return ( ( it != mResourceMap.end() ) ? (*it).second : NULL );
	}

	virtual T* loadResourceById( CResourceId const& id ) = 0;
	virtual void touchResource( T& resource ) = 0;	
	virtual void clearResource( T& resource ) = 0;	
	
private:
	TResourceMap	mResourceMap;
};

#endif
