/**
 *  @file game/MyEntity.h
 *  Your game entity.
 */

#ifndef __GAME_ENTITY_H
#define __GAME_ENTITY_H

#include <d3dx8math.h>

#include "../engine/Entity.h"
#include "Goods.h"

class CPolitician;

#pragma pack(1)


/**
 *  Your game entity.
 */
class CMyEntity : public CEntity {
public:
	enum {
		F_READY_TO_DIE = 1,
		F_KILLED = 2
	};
	enum { DIE_TIME = 40 };
	enum { READY_TIME = 100 };
	
public:
	void	init();
	void	update();
	
public:
	D3DXVECTOR3		mVelocity;
	short			mFlags;
	short			mCounter;
	CPolitician*	mLeader;
	CGoods::eGoods	mPreference;
};

#pragma pack()

#endif
