/**
 *  @file game/MyGame.h
 *  Your game application code.
 */

#ifndef __MY_GAME_H
#define __MY_GAME_H

#include "MyEntity.h"
#include "../engine/BaseGame.h"
#include "../utils/FixedPool.h"
#include "../utils/Singleton.h"

#include "Politician.h"
#include "Promise.h"
#include "../engine/EntityRayPicker.h"
#include "Sectors.h"
#include "Goods.h"




class CBasicCamera;

/**
 *  Your game application class.
 */
class CMyGame : public CBaseGame, public CSingleton<CMyGame>
{
public:

public:
	typedef CFixedPool<CMyEntity>		TPool;
	typedef CFixedPool<CPolitician>		TPolitPool;
	typedef CFixedPool<CPromise>		TPromisePool;
	
public:
	static void init( CConfig& config ) {
		CMyGame* game = new CMyGame( config ); assert( game );
		assignInstance( *game );
	}
	virtual ~CMyGame();

	bool hasSpace() const;
	
protected:
	/// Receive left mouse button change.
	virtual void	onMouseLChange( bool pressed );
	/// Receive right mouse button change.
	virtual void	onMouseRChange( bool pressed );
	/// Receive key state change.
	virtual void	onKeyChange( int key, bool pressed );
	
	/**
	 *  Initialize the game.
	 */
	virtual	void onInitialize();
	
	/**
	 *  Process input.
	 *  The engine calls this method for processing input.
	 */
	virtual void onProcessInput( const CFrameTime& frameTime );

	/**
	 *  Execute game logic.
	 *  The engine calls this method when game update time comes.
	 */
	virtual void onUpdate();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method before rendering anything.
	 */
	virtual void onRenderBeforeAll();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method after rendering all world
	 *  objects.
	 */
	virtual void onRenderAfterWorld();

	/**
	 *  Perform additional rendering.
	 *  The engine calls this method after rendering everything.
	 */
	virtual void onRenderAfterAll();



private:
	bool	isVictory() const;
	int		getNeededKills() const;

protected:
	virtual CCamera* createCamera();

private:
	CMyGame( CConfig& config );

	static CMyGame* createInstance() {
		assert( !"Must be initialized first" );
		return 0;
	}

	static void deleteInstance( CMyGame& instance ) {
		delete &instance;
	}

	void restartGame();

	friend CSingleton<CMyGame>;	

private:
	CBasicCamera*	mTerrainCamera;

public:
	typedef CGrid<SSectorWithRay,4,4>	TRayGrid;
	typedef CGrid<SPoliticalSector,64,64>	TPoliticalGrid;
	
public:
	TPool*			mPool;
	TPolitPool*		mPoliticians;
	TPromisePool*	mPromises;

	bool			mJustChangedPolitician;

	SSectorWithRay	mRay;
	TPoliticalGrid	mPoliticalGrid;

	bool			mIntro;
	int				mTotalTurns;
	int				mTurnNumber;
	bool			mEvilTurn;
	int				mTurnCounter;
	bool			mTurnPause;

	int				mScoreEvil;
	int				mScoreGood;

	int		mLeft[CGoods::MAX_GOODS];

	int				mFrame;
	CGoods::eGoods	mChangePreference;
	CGoods::eGoods	mActiveGoods;
};

#endif
