
#include "Politician.h"
#include "EngineConstants.h"
#include "MyGame.h"
#include "../engine/Terrain.h"
#include "../engine/resource/PictureBundle.h"
#include "../engine/EntityRenderer.h"
#include "../utils/Random.h"



CPolitician::CPolitician( bool evil )
:	CEntity(),
	mEvil(evil),
	mGoods(CGoods::NOTHING)
{
}


void CPolitician::init()
{
	setPicture( *CPictureBundle::getInstance().getResourceById( CResourceId( mEvil ? "Politician1.png" : "Politician2.png" ) ) );
	mCounter = 0;
}


void CPolitician::update()
{
	CMyGame& game = CMyGame::getInstance();

	//
	// set old position
	
	getOldPosition() = getPosition();
	
	D3DXVECTOR3 vel = mVelocity;
	float dx, dy;
	CMyGame::getInstance().getTerrain().getSlope( getPosition().x, getPosition().y, dx, dy );
	
	mVelocity.x += dx * 1.2f;
	mVelocity.y += dy * 1.2f;

	mVelocity *= 0.99f;
	
	D3DXVECTOR3 pos = getPosition() + mVelocity;
	
	//
	// bound to world
	
	if( pos.x >= gcon::WORLD_X || pos.x < 0.0f ) {
		mVelocity.x = -mVelocity.x;
		pos.x = getOldPosition().x;
	}
	if( pos.y >= gcon::WORLD_Y || pos.y < 0.0f ) {
		mVelocity.y = -mVelocity.y;
		pos.y = getOldPosition().y;
	}

	//
	// check change me?

	if( !game.mJustChangedPolitician && mEvil == game.mEvilTurn ) {
		const SSectorWithRay& s = game.mRay;
		if( s.mHasRay ) {
			// if it has a ray, check for intersection with entity
			bool hit = CEntityRayPicker<CMyGame::TRayGrid>::intersects( *this, s );
			if( hit ) {
				mGoods = game.mActiveGoods;
				mCounter = 1;
				game.mJustChangedPolitician = true;
			}
		}
	}
	if( mCounter > SPAWN_TIME ) {
		mCounter = 0;
		mGoods = CGoods::NOTHING;
	}
	
	//
	// terrain height
	
	float h = CMyGame::getInstance().getTerrain().getAltitude( pos.x, pos.y ) + getSize();
	
	mVelocity.z -= gcon::GRAVITY*2.0f;
	if( pos.z < h ) {
		pos.z = h;
		mVelocity.z = -mVelocity.z * 0.6f;
	}

	//
	// spawn promises

	if( mCounter ) {
		++mCounter;
		if( !(mCounter % SPAWN_INTERVAL) ) {
			if( mGoods != CGoods::NOTHING && game.hasSpace() && game.mPromises->hasSpace() ) {
				CPromise& e = game.mPromises->add( CPromise(*this) );
				game.getEntities().add( e );
				e.getPosition() = pos;
				e.getOldPosition() = pos;
				e.setSize( 7.0f );
				e.setColor( 0xFFFFFFFF );
				e.init();
				e.getVelocity() = random::randv3s( 5.0f );
			}
			getVelocity() += random::randv3s( 10.0f );
		}
	}
	
	getPosition() = pos;
}

