
#include "Promise.h"
#include "EngineConstants.h"
#include "MyGame.h"
#include "../engine/Terrain.h"
#include "../engine/resource/PictureBundle.h"



CPromise::CPromise( CPolitician& politician )
:	CEntity(),
	mGoods( politician.getGoods() ),
	mPolitician( &politician )
{
}


void CPromise::init()
{
	const CResourceId* rid = CGoods::getResource( mGoods );
	if( !rid )
		rid = &CResourceId("");
	setPicture( *CPictureBundle::getInstance().getResourceById( *rid ) );

	mVelocity.x = mVelocity.y = mVelocity.z = 0.0f;

	mTTL = INIT_TTL;
}


void CPromise::update()
{
	//
	// set old position
	
	getOldPosition() = getPosition();
	
	D3DXVECTOR3 vel = mVelocity;
	float dx, dy;
	CMyGame::getInstance().getTerrain().getSlope( getPosition().x, getPosition().y, dx, dy );
	
	mVelocity.x -= dx * 0.7f;
	mVelocity.y -= dy * 0.7f;

	mVelocity *= 0.99f;
	
	D3DXVECTOR3 pos = getPosition() + mVelocity;
	
	//
	// bound to world
	
	if( pos.x >= gcon::WORLD_X || pos.x < 0.0f ) {
		mVelocity.x = -mVelocity.x;
		pos.x = getOldPosition().x;
	}
	if( pos.y >= gcon::WORLD_Y || pos.y < 0.0f ) {
		mVelocity.y = -mVelocity.y;
		pos.y = getOldPosition().y;
	}
	
	//
	// terrain height
	
	float h = CMyGame::getInstance().getTerrain().getAltitude( pos.x, pos.y ) + getSize();
	
	pos.z = h;

	--mTTL;

	//
	// put me into sectors

	if( mTTL >= 2 ) {
		SPoliticalSector& s = CMyGame::getInstance().mPoliticalGrid.getSectorByPosition( pos.x, pos.y );
		s.mPromise = this;
	}
	
	getPosition() = pos;
}
