#pragma warning( disable:4786 )
#ifndef __SINGLETON_H
#define __SINGLETON_H


template<class T>
class CSingleton {
public:
	static T& getInstance() {
		if( !mSingleInstance )
			mSingleInstance = T::createInstance();
		return *mSingleInstance;
	}

	static void finalize() {
		if( !mSingleInstance )
			return;
		T::deleteInstance( *mSingleInstance );
		mSingleInstance = 0;
	}

protected:
	static void assignInstance( T& instance ) {
		mSingleInstance = &instance;
	}

private:
	static T*	mSingleInstance;
};

template <class T>
T* CSingleton<T>::mSingleInstance = 0;

#endif
