/**
 *  @file engine/EntityRenderer.h
 *  Entity renderer.
 */
#ifndef __ENTITY_RENDERER_H
#define __ENTITY_RENDERER_H

#include "DXObject.h"
#include "Sprite.h"


class	CEntity;
class	CCamera;
class	CFrameTime;
struct	SVertexXyzDiffuseTex1;


/**
 *  Entity renderer.
 *
 *  When you add() and entity to the renderer, it becomes visible; and
 *  it stays visible until you remove() it.
 *
 *  To access the renderer use CEngine.
 *  @see CEngine.
 */
class CEntityRenderer : public CDXObject {
public:
	enum { BUFFER_SIZE = 12288 };
	enum { LOCK_SIZE = BUFFER_SIZE/12 };

private:
	typedef SVertexXyzDiffuseTex1	TVertex;

public:
	/**
	 *  Constructor.
	 *  @param maxEntities Maximum number of entities.
	 */
	CEntityRenderer( int maxEntities, CCamera const& camera, float const& alpha );
	virtual ~CEntityRenderer();

	/// Returns maximum number of entities allowed.
	int getMaxEntities() const { return mMaxEntities; }
	/// Returns current entity count.
	int getEntityCount() const { return mEntityCount; }

	/// Adds entity for rendering.
	void	add( CEntity& entity );
	/// Removes entity from rendering.
	void	remove( CEntity& entity );

	virtual HRESULT onCreateDevice( IDirect3DDevice8* device );
	virtual HRESULT onLostDevice();
	virtual HRESULT onResetDevice();
	virtual HRESULT onDestroyDevice();

	virtual void render( CFrameTime const& frameTime );

private:
	int						mMaxEntities;

	// the sprites
	SSpriteData*			mSprites;
	CEntity**				mEntityPtrs;
	int						mEntityCount;

	// for rendering
	IDirect3DIndexBuffer8*	mIB;
	IDirect3DVertexBuffer8*	mVB;

	CCamera const&			mCamera;
	float const&			mAlpha;
};

#endif