
#include "Utils.h"
#include "../game/EngineConstants.h"
#include <cassert>


static const float SMALL = ((gcon::WORLD_X)+(gcon::WORLD_Y)) * 0.0001f;

bool utils::boundToWorld( D3DXVECTOR3& or, const D3DXVECTOR3& dir, float minZ, float maxZ )
{
	//
	// faces away from the terrain (xy)?

	if( or.x < 0.0f && dir.x < SMALL || or.x >= gcon::WORLD_X && dir.x > -SMALL )
		return false;
	if( or.y < 0.0f && dir.y < SMALL || or.y >= gcon::WORLD_Y && dir.y > -SMALL )
		return false;
	
	//
	// move origin along the ray so our xy is in valid terrain range

	float k;
	if( or.x < 0.0f ) {
		k = (0.0f-or.x) / dir.x * 1.01f;
		or += dir * k;
	} else if( or.x >= gcon::WORLD_X ) {
		k = (gcon::WORLD_X-or.x) / dir.x * 1.01f;
		or += dir * k;
	}
	if( or.y < 0.0f ) {
		k = (0.0f-or.y) / dir.y * 1.01f;
		or += dir * k;
	} else if( or.y >= gcon::WORLD_Y ) {
		k = (gcon::WORLD_Y-or.y) / dir.y * 1.01f;
		or += dir * k;
	}
	if( or.x < 0.0f || or.x >= gcon::WORLD_X || or.y < 0.0f || or.y >= gcon::WORLD_Y )
		return false;

	//
	// faces away from the terrain (z)?
	
	if( or.z >= maxZ && dir.z > -SMALL )
		return false;
	if( or.z <= minZ && dir.z < SMALL )
		return false;
	//
	// move origin along the ray so our z is in min..max z range

	bool reCheck = false;
	if( or.z > maxZ ) {
		k = (maxZ-or.z) / dir.z * 1.01f;
		or += dir * k;
		reCheck = true;
	} else if( or.z < minZ ) {
		k = (minZ-or.z+SMALL) / dir.z * 1.01f;
		or += dir * k;
		reCheck = true;
	}
	assert( or.z >= minZ && or.z <= maxZ );
	if( reCheck ) {
		if( or.x < 0.0f || or.x >= gcon::WORLD_X || or.y < 0.0f || or.y >= gcon::WORLD_Y )
			return false;
	}

	return true;
}
