#pragma warning( disable:4786 )
#include "EffectBundle.h"

#include <cassert>
#include "../../utils/Errors.h"


CEffectBundle::CEffectBundle( IDirect3DDevice8& device, std::string const& predir )
:	mDevice( device ), mPreDir( predir )
{
}

CEffectBundle::~CEffectBundle()
{
	// HACK: in order to clear resources
	clear();
	CONSOLE.write( "effect bundle destroyed" );	
}

ID3DXEffect* CEffectBundle::loadResourceById( CResourceId const& id )
{
	ID3DXBuffer* errors = NULL;
	ID3DXEffect* effect = NULL;
	
	HRESULT hres = D3DXCreateEffectFromFile(
		&mDevice,
		( mPreDir + id.getUniqueName() ).c_str(),
		&effect,
		&errors );

	if( FAILED( hres ) && errors && errors->GetBufferSize() > 1 )
		CON_ERROR.write( std::string( (char*)errors->GetBufferPointer() ) );

	if( FAILED( hres ) ) {
		THROW_DXERROR( hres, "failed to compile effect '" + id.getUniqueName() + "'" );
	}

	// empty used resources
	if( errors )
		errors->Release();

	D3DXTECHNIQUE_DESC tech;
	hres = effect->FindNextValidTechnique( NULL, &tech );
	if( FAILED( hres ) )
		CON_ERROR.write( std::string( "no valid techniques found for '" + id.getUniqueName() + "'" ) );
	if( FAILED( hres ) ) {
		THROW_DXERROR( hres, "no valid techniques found for '" + id.getUniqueName() + "'" );
	}
	effect->SetTechnique( tech.Index );
	
	CONSOLE.write( "effect loaded '" + id.getUniqueName() + "'" );	
	return effect;
}

void CEffectBundle::touchResource( ID3DXEffect& resource )
{
	resource.AddRef();
}

void CEffectBundle::clearResource( ID3DXEffect& resource )
{
	// DEBUG
	ULONG i = resource.Release();
}
